/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.annotations.Transferable;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

@Transferable(value=61)
public interface ClusterState
extends NetworkMessage,
Serializable {
    public Set<String> cmgNodes();

    public Set<String> metaStorageNodes();

    public String version();

    public ClusterTag clusterTag();

    default public IgniteProductVersion igniteVersion() {
        return IgniteProductVersion.fromString((String)this.version());
    }

    @Nullable
    public String initialClusterConfiguration();

    @Nullable
    public List<UUID> formerClusterIds();

    default public List<UUID> clusterIdHistory() {
        List<UUID> formerClusterIds = this.formerClusterIds();
        UUID currentClusterId = this.clusterTag().clusterId();
        if (formerClusterIds == null) {
            return List.of(currentClusterId);
        }
        ArrayList<UUID> history = new ArrayList<UUID>(formerClusterIds);
        history.add(currentClusterId);
        return history;
    }
}

