/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore.status;

import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.metastore.status.UnitKey;
import org.apache.ignite.internal.lang.ByteArray;

public class NodeStatusKey {
    private static final String NODES_PREFIX = "deploy-unit.nodes.";
    private final String id;
    private final Version version;
    private final String nodeId;

    private NodeStatusKey(String id, Version version, String nodeId) {
        this.id = id;
        this.version = version;
        this.nodeId = nodeId;
    }

    public ByteArray toByteArray() {
        return UnitKey.toByteArray(NODES_PREFIX, this.id, this.version == null ? null : this.version.render(), this.nodeId);
    }

    public static NodeStatusKey fromBytes(byte[] key) {
        String[] parse = UnitKey.fromBytes(NODES_PREFIX, key);
        int length = parse.length;
        String id = length > 0 ? parse[0] : null;
        Version version = length > 1 ? Version.parseVersion((String)parse[1]) : null;
        String nodeId = length > 2 ? parse[2] : null;
        return NodeStatusKey.builder().id(id).version(version).nodeId(nodeId).build();
    }

    public static NodeStatusKeyBuilder builder() {
        return new NodeStatusKeyBuilder();
    }

    public String id() {
        return this.id;
    }

    public Version version() {
        return this.version;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatusKey that = (NodeStatusKey)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals((Object)that.version) : that.version != null) {
            return false;
        }
        return this.nodeId != null ? this.nodeId.equals(that.nodeId) : that.nodeId == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    public static class NodeStatusKeyBuilder {
        private String id;
        private Version version;
        private String nodeId;

        public NodeStatusKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NodeStatusKeyBuilder version(Version version) {
            this.version = version;
            return this;
        }

        public NodeStatusKeyBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public NodeStatusKey build() {
            return new NodeStatusKey(this.id, this.version, this.nodeId);
        }
    }
}

