/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.presentation;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.exception.ConfigurationApplyException;
import org.apache.ignite.internal.configuration.exception.ConfigurationParseException;
import org.apache.ignite.internal.configuration.exception.ConfigurationValidationIgniteException;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class HoconPresentation
implements ConfigurationPresentation<String> {
    private final ConfigurationRegistry registry;

    public HoconPresentation(ConfigurationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String represent() {
        return this.representByPath(null);
    }

    @Override
    public String representByPath(@Nullable String path) {
        return HoconConverter.represent((TraversableTreeNode)this.registry.superRoot(), (List)(path == null ? List.of() : ConfigurationUtil.split((String)path))).render(ConfigRenderOptions.concise());
    }

    @Override
    public CompletableFuture<Void> update(String cfgUpdate) {
        Config config;
        if (cfgUpdate.isBlank()) {
            return CompletableFuture.failedFuture((Throwable)((Object)new ConfigurationParseException("Empty configuration.")));
        }
        try {
            config = ConfigFactory.parseString((String)cfgUpdate);
        }
        catch (ConfigException.Parse e2) {
            return CompletableFuture.failedFuture((Throwable)((Object)new ConfigurationParseException("Failed to parse configuration.", e2)));
        }
        return this.registry.change(HoconConverter.hoconSource((ConfigObject)config.root(), (KeyIgnorer)this.registry.keyIgnorer())).exceptionally(e -> {
            if ((e = ExceptionUtils.unwrapCause((Throwable)e)) instanceof ConfigurationChangeException) {
                e = e.getCause();
            }
            if (e instanceof ConfigurationValidationException) {
                throw new ConfigurationValidationIgniteException((ConfigurationValidationException)e);
            }
            throw new ConfigurationApplyException("Failed to apply configuration.", (Throwable)e);
        });
    }
}

