/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Set;
import java.util.function.BiFunction;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.Named;
import org.checkerframework.checker.nullness.qual.Nullable;

class TransformingLookup<S, T>
implements Lookup<T> {
    private final Lookup<S> lookup;
    private final BiFunction<S, String, T> transform;

    TransformingLookup(Lookup<S> lookup, BiFunction<S, String, T> transform) {
        this.lookup = lookup;
        this.transform = transform;
    }

    @Override
    public @Nullable T get(String name) {
        S entity = this.lookup.get(name);
        return entity == null ? null : (T)this.transform.apply(entity, name);
    }

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        Named<S> named = this.lookup.getIgnoreCase(name);
        return named == null ? null : new Named<T>(named.name(), this.transform.apply(named.entity(), named.name()));
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        return this.lookup.getNames(pattern);
    }
}

