/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricReusableDataMarshaler;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    final AggregationTemporalitySelector aggregationTemporalitySelector;
    final DefaultAggregationSelector defaultAggregationSelector;
    private final MetricReusableDataMarshaler marshaler;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.marshaler = new MetricReusableDataMarshaler(memoryMode, (arg_0, arg_1) -> delegate.export(arg_0, arg_1));
    }

    public OtlpGrpcMetricExporterBuilder toBuilder() {
        return new OtlpGrpcMetricExporterBuilder((GrpcExporterBuilder<Marshaler>)this.builder.copy(), this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.marshaler.getMemoryMode());
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    public MemoryMode getMemoryMode() {
        return this.marshaler.getMemoryMode();
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.marshaler.export(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcMetricExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("aggregationTemporalitySelector=" + AggregationTemporalitySelector.asString((AggregationTemporalitySelector)this.aggregationTemporalitySelector));
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString((DefaultAggregationSelector)this.defaultAggregationSelector));
        joiner.add("memoryMode=" + this.marshaler.getMemoryMode());
        return joiner.toString();
    }
}

