/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommandV2;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommandV2Builder;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class UpdateAllCommandV2Deserializer
implements MessageDeserializer<UpdateAllCommandV2> {
    private final UpdateAllCommandV2Builder msg;

    UpdateAllCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.updateAllCommandV2();
    }

    public Class<UpdateAllCommandV2> klass() {
        return UpdateAllCommandV2.class;
    }

    public UpdateAllCommandV2 getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime((Long)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readMap("messageRowsToUpdate", MessageCollectionItemType.UUID, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.messageRowsToUpdate((Map<UUID, TimedBinaryRowMessage>)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 6: {
                UUID tmp = (ReplicationGroupIdMessage)reader.readMessage("tablePartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 7: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txCoordinatorId(tmp);
                reader.incrementState();
            }
            case 8: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateAllCommandV2.class);
    }
}

