/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.compute.AllNodesBroadcastJobTarget;
import org.apache.ignite.compute.AnyNodeJobTarget;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.BroadcastJobTarget;
import org.apache.ignite.compute.ColocatedJobTarget;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.compute.NodeNotFoundException;
import org.apache.ignite.compute.TableJobTarget;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.MapReduceJob;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite.internal.compute.BroadcastJobExecutionImpl;
import org.apache.ignite.internal.compute.CancellableTaskExecution;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.FailedExecution;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.JobExecutionWrapper;
import org.apache.ignite.internal.compute.NextColocatedWorkerSelector;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.compute.ResultUnmarshallingJobExecution;
import org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.internal.compute.TaskExecutionWrapper;
import org.apache.ignite.internal.compute.streamer.StreamerReceiverJob;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.StreamerReceiverRunner;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.CancelHandleHelper;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.Partition;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteComputeImpl
implements IgniteComputeInternal,
StreamerReceiverRunner {
    private final TopologyService topologyService;
    private final IgniteTablesInternal tables;
    private final ComputeComponent computeComponent;
    private final PlacementDriver placementDriver;
    private final HybridClock clock;

    public IgniteComputeImpl(PlacementDriver placementDriver, TopologyService topologyService, IgniteTablesInternal tables, ComputeComponent computeComponent, HybridClock clock) {
        this.placementDriver = placementDriver;
        this.topologyService = topologyService;
        this.tables = tables;
        this.computeComponent = computeComponent;
        this.clock = clock;
        tables.setStreamerReceiverRunner((StreamerReceiverRunner)this);
    }

    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T args, @Nullable CancellationToken cancellationToken) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(descriptor);
        ComputeJobDataHolder argHolder = SharedComputeUtils.marshalArgOrResult(args, (Marshaller)descriptor.argumentMarshaller());
        if (target instanceof AnyNodeJobTarget) {
            Set nodes = ((AnyNodeJobTarget)target).nodes();
            return CompletableFuture.completedFuture(IgniteComputeImpl.unmarshalResult(this.executeAsyncWithFailover(nodes, descriptor.units(), descriptor.jobClassName(), descriptor.options(), argHolder, cancellationToken), descriptor));
        }
        if (target instanceof ColocatedJobTarget) {
            ColocatedJobTarget colocatedTarget = (ColocatedJobTarget)target;
            Mapper mapper = colocatedTarget.keyMapper();
            String tableName = colocatedTarget.tableName();
            Object key = colocatedTarget.key();
            CompletionStage jobFut = mapper != null ? this.requiredTable(tableName).thenCompose(table -> this.primaryReplicaForPartitionByMappedKey((TableViewInternal)table, (Object)key, (Mapper)mapper).thenApply(primaryNode -> this.executeOnOneNodeWithFailover((ClusterNode)primaryNode, (NextWorkerSelector)new NextColocatedWorkerSelector<Object>(this.placementDriver, this.topologyService, this.clock, (TableViewInternal)table, key, (Mapper<Object>)mapper), (List<DeploymentUnit>)descriptor.units(), descriptor.jobClassName(), descriptor.options(), argHolder, cancellationToken))) : this.requiredTable(tableName).thenCompose(table -> this.submitColocatedInternal((TableViewInternal)table, (Tuple)key, descriptor.units(), descriptor.jobClassName(), descriptor.options(), argHolder, cancellationToken));
            return ((CompletableFuture)jobFut).thenApply(execution -> IgniteComputeImpl.unmarshalResult((JobExecution<ComputeJobDataHolder>)execution, descriptor));
        }
        throw new IllegalArgumentException("Unsupported job target: " + String.valueOf(target));
    }

    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(descriptor);
        ComputeJobDataHolder argHolder = SharedComputeUtils.marshalArgOrResult(arg, (Marshaller)descriptor.argumentMarshaller());
        if (target instanceof AllNodesBroadcastJobTarget) {
            AllNodesBroadcastJobTarget allNodesBroadcastTarget = (AllNodesBroadcastJobTarget)target;
            Set nodes = allNodesBroadcastTarget.nodes();
            return CompletableFuture.completedFuture(new BroadcastJobExecutionImpl((Collection)nodes.stream().map(node -> this.submitForBroadcast((ClusterNode)node, descriptor, argHolder, cancellationToken)).collect(Collectors.toList())));
        }
        if (target instanceof TableJobTarget) {
            TableJobTarget tableJobTarget = (TableJobTarget)target;
            return ((CompletableFuture)this.requiredTable(tableJobTarget.tableName()).thenCompose(table -> table.partitionManager().primaryReplicasAsync())).thenApply(replicas -> new BroadcastJobExecutionImpl((Collection)replicas.entrySet().stream().map(entry -> this.submitForBroadcast((ClusterNode)entry.getValue(), (Partition)entry.getKey(), descriptor, argHolder, cancellationToken)).collect(Collectors.toList())));
        }
        throw new IllegalArgumentException("Unsupported job target: " + String.valueOf(target));
    }

    private <T, R> JobExecution<R> submitForBroadcast(ClusterNode node, JobDescriptor<T, R> descriptor, @Nullable ComputeJobDataHolder argHolder, @Nullable CancellationToken cancellationToken) {
        ExecutionOptions options = ExecutionOptions.from(descriptor.options());
        return this.submitForBroadcast(node, descriptor, options, argHolder, cancellationToken);
    }

    private <T, R> JobExecution<R> submitForBroadcast(ClusterNode node, @Nullable Partition partition, JobDescriptor<T, R> descriptor, @Nullable ComputeJobDataHolder argHolder, @Nullable CancellationToken cancellationToken) {
        ExecutionOptions options = ExecutionOptions.builder().priority(descriptor.options().priority()).maxRetries(descriptor.options().maxRetries()).partition(partition).build();
        return this.submitForBroadcast(node, descriptor, options, argHolder, cancellationToken);
    }

    private <T, R> JobExecution<R> submitForBroadcast(ClusterNode node, JobDescriptor<T, R> descriptor, ExecutionOptions options, @Nullable ComputeJobDataHolder argHolder, @Nullable CancellationToken cancellationToken) {
        if (this.topologyService.getByConsistentId(node.name()) == null) {
            return new FailedExecution((Throwable)new NodeNotFoundException(Set.of(node.name())));
        }
        return IgniteComputeImpl.unmarshalResult(this.executeOnOneNodeWithFailover(node, CompletableFutures::nullCompletedFuture, (List<DeploymentUnit>)descriptor.units(), descriptor.jobClassName(), options, argHolder, cancellationToken), descriptor);
    }

    private static <T, R> JobExecution<R> unmarshalResult(JobExecution<ComputeJobDataHolder> execution, JobDescriptor<T, R> descriptor) {
        return new ResultUnmarshallingJobExecution(execution, descriptor.resultMarshaller(), descriptor.resultClass());
    }

    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return IgniteComputeImpl.sync(this.executeAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (Collection)IgniteComputeImpl.sync(this.executeAsync(target, descriptor, arg, cancellationToken));
    }

    @Override
    public JobExecution<ComputeJobDataHolder> executeAsyncWithFailover(Set<ClusterNode> nodes, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions options, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        HashSet<ClusterNode> candidates = new HashSet<ClusterNode>();
        for (ClusterNode node : nodes) {
            if (this.topologyService.getByConsistentId(node.name()) == null) continue;
            candidates.add(node);
        }
        if (candidates.isEmpty()) {
            Set nodeNames = nodes.stream().map(ClusterNode::name).collect(Collectors.toSet());
            return new FailedExecution((Throwable)new NodeNotFoundException(nodeNames));
        }
        ClusterNode targetNode = IgniteComputeImpl.randomNode(candidates);
        candidates.remove(targetNode);
        DeqNextWorkerSelector selector = new DeqNextWorkerSelector(new ConcurrentLinkedDeque<ClusterNode>(candidates));
        return this.executeOnOneNodeWithFailover(targetNode, (NextWorkerSelector)selector, units, jobClassName, options, arg, cancellationToken);
    }

    private static ClusterNode randomNode(Set<ClusterNode> nodes) {
        int nodesToSkip = ThreadLocalRandom.current().nextInt(nodes.size());
        Iterator<ClusterNode> iterator = nodes.iterator();
        for (int i = 0; i < nodesToSkip; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    private JobExecution<ComputeJobDataHolder> executeOnOneNodeWithFailover(ClusterNode targetNode, NextWorkerSelector nextWorkerSelector, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions jobExecutionOptions, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        ExecutionOptions options = ExecutionOptions.from(jobExecutionOptions);
        return this.executeOnOneNodeWithFailover(targetNode, nextWorkerSelector, units, jobClassName, options, arg, cancellationToken);
    }

    private JobExecution<ComputeJobDataHolder> executeOnOneNodeWithFailover(ClusterNode targetNode, NextWorkerSelector nextWorkerSelector, List<DeploymentUnit> units, String jobClassName, ExecutionOptions options, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        if (this.isLocal(targetNode)) {
            return new JobExecutionWrapper<ComputeJobDataHolder>(this.computeComponent.executeLocally(options, units, jobClassName, arg, cancellationToken));
        }
        return new JobExecutionWrapper<ComputeJobDataHolder>(this.computeComponent.executeRemotelyWithFailover(targetNode, nextWorkerSelector, units, jobClassName, options, arg, cancellationToken));
    }

    private boolean isLocal(ClusterNode targetNode) {
        return targetNode.name().equals(this.topologyService.localMember().name());
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitColocatedInternal(TableViewInternal table, Tuple key, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions options, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        return this.primaryReplicaForPartitionByTupleKey(table, key).thenApply(primaryNode -> this.executeOnOneNodeWithFailover((ClusterNode)primaryNode, (NextWorkerSelector)new NextColocatedWorkerSelector(this.placementDriver, this.topologyService, this.clock, table, key), units, jobClassName, options, arg, cancellationToken));
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitPartitionedInternal(TableViewInternal table, int partitionId, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions jobExecutionOptions, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        ExecutionOptions options = ExecutionOptions.builder().priority(jobExecutionOptions.priority()).maxRetries(jobExecutionOptions.maxRetries()).partition((Partition)new HashPartition(partitionId)).build();
        return this.primaryReplicaForPartition(table, partitionId).thenApply(primaryNode -> this.executeOnOneNodeWithFailover((ClusterNode)primaryNode, CompletableFutures::nullCompletedFuture, units, jobClassName, options, arg, cancellationToken));
    }

    private CompletableFuture<TableViewInternal> requiredTable(String tableName) {
        String parsedName = IgniteNameUtils.parseSimpleName((String)tableName);
        return this.tables.tableViewAsync(parsedName).thenApply(table -> {
            if (table == null) {
                throw new TableNotFoundException("PUBLIC", parsedName);
            }
            return table;
        });
    }

    private CompletableFuture<ClusterNode> primaryReplicaForPartitionByTupleKey(TableViewInternal table, Tuple key) {
        return this.primaryReplicaForPartition(table, table.partitionId(key));
    }

    private <K> CompletableFuture<ClusterNode> primaryReplicaForPartitionByMappedKey(TableViewInternal table, K key, Mapper<K> keyMapper) {
        return this.primaryReplicaForPartition(table, table.partitionId(key, keyMapper));
    }

    private CompletableFuture<ClusterNode> primaryReplicaForPartition(TableViewInternal table, int partitionIndex) {
        TablePartitionId tablePartitionId = new TablePartitionId(table.tableId(), partitionIndex);
        return this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)tablePartitionId, this.clock.now(), 30L, TimeUnit.SECONDS).thenApply(replicaMeta -> {
            if (replicaMeta != null && replicaMeta.getLeaseholderId() != null) {
                return this.topologyService.getById(replicaMeta.getLeaseholderId());
            }
            throw new ComputeException(ErrorGroups.Compute.PRIMARY_REPLICA_RESOLVE_ERR, "Can not find primary replica for [table=" + table.name() + ", partition=" + partitionIndex + "].");
        });
    }

    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        Objects.requireNonNull(taskDescriptor);
        CancellableTaskExecution taskExecution = this.computeComponent.executeTask(this::submitJobs, taskDescriptor.units(), taskDescriptor.taskClassName(), arg);
        if (cancellationToken != null) {
            CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, taskExecution::cancelAsync, (CompletableFuture)taskExecution.resultAsync());
        }
        return new TaskExecutionWrapper(taskExecution);
    }

    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return IgniteComputeImpl.sync(this.executeMapReduceAsync(taskDescriptor, arg, cancellationToken));
    }

    private <M, T> CompletableFuture<List<JobExecution<T>>> submitJobs(List<MapReduceJob<M, T>> runners, CancellationToken cancellationToken) {
        return CompletableFutures.allOfToList((CompletableFuture[])((CompletableFuture[])runners.stream().map(runner -> this.submitAsync(JobTarget.anyNode((Set)runner.nodes()), runner.jobDescriptor(), runner.arg(), cancellationToken)).toArray(CompletableFuture[]::new)));
    }

    @Override
    public CompletableFuture<Collection<JobState>> statesAsync() {
        return this.computeComponent.statesAsync();
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync(UUID jobId) {
        return this.computeComponent.stateAsync(jobId);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync(UUID jobId) {
        return this.computeComponent.cancelAsync(jobId);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(UUID jobId, int newPriority) {
        return this.computeComponent.changePriorityAsync(jobId, newPriority);
    }

    public <A, I, R> CompletableFuture<Collection<R>> runReceiverAsync(ReceiverDescriptor<A> receiver, @Nullable A receiverArg, Collection<I> items, ClusterNode node, List<DeploymentUnit> deploymentUnits) {
        byte[] payload = StreamerReceiverSerializer.serializeReceiverInfoWithElementCount(receiver, receiverArg, items);
        return this.runReceiverAsync(payload, node, deploymentUnits).thenApply(StreamerReceiverSerializer::deserializeReceiverJobResults);
    }

    public CompletableFuture<byte[]> runReceiverAsync(byte[] payload, ClusterNode node, List<DeploymentUnit> deploymentUnits) {
        JobExecution<ComputeJobDataHolder> jobExecution = this.executeAsyncWithFailover(Set.of(node), deploymentUnits, StreamerReceiverJob.class.getName(), JobExecutionOptions.DEFAULT, SharedComputeUtils.marshalArgOrResult((Object)payload, null), null);
        return jobExecution.resultAsync().handle((res, err) -> {
            if (err != null) {
                if (err.getCause() instanceof ComputeException) {
                    ComputeException computeErr = (ComputeException)err.getCause();
                    throw new IgniteException(ErrorGroups.Compute.COMPUTE_JOB_FAILED_ERR, "Streamer receiver failed: " + computeErr.getMessage(), (Throwable)computeErr);
                }
                ExceptionUtils.sneakyThrow((Throwable)err);
            }
            return (byte[])SharedComputeUtils.unmarshalArgOrResult((ComputeJobDataHolder)res, null, null);
        });
    }

    public OperationKillHandler killHandler() {
        return new OperationKillHandler(){

            public CompletableFuture<Boolean> cancelAsync(String operationId) {
                UUID jobId = UUID.fromString(operationId);
                return IgniteComputeImpl.this.cancelAsync(jobId).thenApply(res -> res != null ? res : Boolean.FALSE);
            }

            public boolean local() {
                return false;
            }

            public CancellableOperationType type() {
                return CancellableOperationType.COMPUTE;
            }
        };
    }

    @TestOnly
    ComputeComponent computeComponent() {
        return this.computeComponent;
    }

    private static <R> R sync(CompletableFuture<R> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)IgniteExceptionMapperUtil.mapToPublicException((Throwable)ExceptionUtils.unwrapCause((Throwable)e)));
        }
    }

    private static class DeqNextWorkerSelector
    implements NextWorkerSelector {
        private final ConcurrentLinkedDeque<ClusterNode> deque;

        private DeqNextWorkerSelector(ConcurrentLinkedDeque<ClusterNode> deque) {
            this.deque = deque;
        }

        @Override
        public CompletableFuture<ClusterNode> next() {
            try {
                return CompletableFuture.completedFuture(this.deque.pop());
            }
            catch (NoSuchElementException ex) {
                return CompletableFutures.nullCompletedFuture();
            }
        }
    }
}

