/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public abstract class TablePrimaryKey {
    private final List<String> columns;

    TablePrimaryKey(List<String> columns) {
        this.columns = columns != null ? List.copyOf(columns) : List.of();
    }

    public List<String> columns() {
        return this.columns;
    }

    void validate(List<ColumnParams> allColumns) {
        HashSet<String> allColumnNames = new HashSet<String>(allColumns.size());
        for (ColumnParams column : allColumns) {
            allColumnNames.add(column.name());
            boolean partOfPk = this.columns.contains(column.name());
            if (!partOfPk || !column.nullable()) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Primary key cannot contain nullable column [col={}].", (Object[])new Object[]{column.name()}));
        }
        List columnsNotInTable = this.columns.stream().filter(Predicate.not(allColumnNames::contains)).collect(Collectors.toList());
        if (!columnsNotInTable.isEmpty()) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Primary key constraint contains undefined columns: [cols={}].", (Object[])new Object[]{columnsNotInTable}));
        }
        HashSet<String> columnSet = new HashSet<String>();
        for (String name : this.columns) {
            if (columnSet.add(name)) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"PK column '{}' specified more that once.", (Object[])new Object[]{name}));
        }
    }

    public static abstract class TablePrimaryKeyBuilder<T extends TablePrimaryKeyBuilder<T>> {
        public abstract T columns(List<String> var1);

        public abstract TablePrimaryKey build();
    }
}

