/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.recovery.GlobalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.ResetPartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartPartitionsRequest;

@Controller(value="/management/v1/recovery")
@Tag(name="recovery")
public interface DisasterRecoveryApi {
    @Get(value="state/local")
    @Operation(operationId="getLocalPartitionStates", description="Returns local partition states.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Partition states returned."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public CompletableFuture<LocalPartitionStatesResponse> getLocalPartitionStates(@QueryValue @Schema(description="Names specifying zones to get partition states from. Case-sensitive, all zones if empty.") Optional<Set<String>> var1, @QueryValue @Schema(description="Names specifying nodes to get partition states from. Case-sensitive, all nodes if empty.") Optional<Set<String>> var2, @QueryValue @Schema(description="IDs of partitions to get states. All partitions if empty.") Optional<Set<Integer>> var3);

    @Get(value="state/global")
    @Operation(operationId="getGlobalPartitionStates", description="Returns global partition states.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Partition states returned."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public CompletableFuture<GlobalPartitionStatesResponse> getGlobalPartitionStates(@QueryValue @Schema(description="Names specifying zones to get partition states from. Case-sensitive, all zones if empty.") Optional<Set<String>> var1, @QueryValue @Schema(description="IDs of partitions to get states of. All partitions if empty.") Optional<Set<Integer>> var2);

    @Post(value="partitions/reset")
    @Operation(operationId="resetPartitions", description="Updates assignments of partitions in a forced manner, allowing for the recovery of raft groups with lost majorities.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Partition states reset."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> resetPartitions(@Body ResetPartitionsRequest var1);

    @Post(value="partitions/restart")
    @Operation(operationId="restartPartitions", description="Restarts replica service and raft group of passed partitions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Partitions restarted."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> restartPartitions(@Body RestartPartitionsRequest var1);
}

