/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ignite.marshalling.MarshallingException;
import org.jetbrains.annotations.Nullable;

class JavaSerializationByteArrayMarshalling {
    JavaSerializationByteArrayMarshalling() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> byte @Nullable [] marshal(T object) {
        if (object == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                out.writeObject(object);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T unmarshal(byte @Nullable [] raw) {
        if (raw == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(raw);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MarshallingException(e);
        }
    }
}

