/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;

public class IgniteCollect
extends Collect
implements IgniteRel {
    public IgniteCollect(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelDataType rowType) {
        super(cluster, traits, input, rowType);
    }

    public IgniteCollect(RelInput input) {
        super(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getInput(), IgniteCollect.deriveRowType((RelDataTypeFactory)input.getCluster().getTypeFactory(), (SqlTypeName)((SqlTypeName)input.getEnum("collectionType", SqlTypeName.class)), (String)Objects.requireNonNull(input.getString("field"), "field"), (RelDataType)input.getInput().getRowType()));
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteCollect(cluster, this.getTraitSet(), (RelNode)IgniteCollect.sole(inputs), this.rowType);
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new IgniteCollect(this.getCluster(), traitSet, input, this.rowType());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("collectionType", (Object)this.getCollectionType());
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        if (required.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        if (TraitUtils.distribution(required) != IgniteDistributions.single()) {
            return null;
        }
        if (TraitUtils.collation(required) != RelCollations.EMPTY) {
            return null;
        }
        return Pair.of((Object)required, (Object)ImmutableList.of((Object)required));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        assert (childId == 0);
        if (childTraits.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        if (TraitUtils.distribution(childTraits) != IgniteDistributions.single()) {
            return null;
        }
        return Pair.of((Object)childTraits.replace((RelTrait)RelCollations.EMPTY), (Object)ImmutableList.of((Object)childTraits));
    }
}

