/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.binary;

import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

/**
 *
 */
public class BinaryContextPredefinedTypesTest extends GridCommonAbstractTest {
    /**
     * Tests that all predefined types have default constructor.
     */
    @Test
    public void testDefaultConstructor() {
        BinaryContext binCtx = new BinaryContext(BinaryNoopMetadataHandler.instance(), new IgniteConfiguration(), log);

        for (BinaryClassDescriptor desc : binCtx.predefinedTypes()) {
            if (!desc.isBinary())
                continue;

            // Check that class descriptor uses default class constructor (not generated by U.ctorFactory()).
            // Ignite can't start if any predefined type misses default constructor and U.ctorFactory() is not available
            // (this can happens in some environments, for example, inside application server)
            assertTrue("Missing default constructor for predifined type " + desc.describedClass().getName(),
                desc.describedClass() == desc.ctor().getDeclaringClass());
        }
    }
}
