/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelInputEx;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;

public class IgniteSortedIndexSpool
extends Spool
implements IgniteRel {
    private final RelCollation collation;
    private final List<SearchBounds> searchBounds;
    protected final RexNode condition;

    public IgniteSortedIndexSpool(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode condition, List<SearchBounds> searchBounds) {
        super(cluster, traits, input, Spool.Type.LAZY, Spool.Type.EAGER);
        assert (Objects.nonNull(condition));
        this.searchBounds = searchBounds;
        this.condition = condition;
        this.collation = collation;
    }

    public IgniteSortedIndexSpool(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), input.getCollation(), input.getExpression("condition"), ((RelInputEx)input).getSearchBounds("searchBounds"));
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSortedIndexSpool(cluster, this.getTraitSet(), (RelNode)inputs.get(0), this.collation, this.condition, this.searchBounds);
    }

    protected Spool copy(RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType) {
        return new IgniteSortedIndexSpool(this.getCluster(), traitSet, input, this.collation, this.condition, this.searchBounds);
    }

    public boolean isEnforcer() {
        return true;
    }

    public RelWriter explainTerms(RelWriter pw) {
        RelWriter writer = super.explainTerms(pw);
        writer.item("condition", (Object)this.condition);
        writer.item("collation", (Object)this.collation);
        writer.itemIf("searchBounds", this.searchBounds, this.searchBounds != null);
        return writer;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.getInput()) * mq.getSelectivity((RelNode)this, null);
    }

    public List<SearchBounds> searchBounds() {
        return this.searchBounds;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    public RexNode condition() {
        return this.condition;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCnt = mq.getRowCount(this.getInput());
        double bytesPerRow = (double)this.getRowType().getFieldCount() * 4.0;
        double totalBytes = rowCnt * bytesPerRow;
        double cpuCost = this.searchBounds != null ? Math.log(rowCnt) * 3.0 : rowCnt * 1.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCnt, cpuCost, 0.0, totalBytes, 0.0);
    }
}

