/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.RequestTE;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestTE {
    TestRequestTE() {
    }

    @Test
    void testValidTEHeader() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers");
        request.setHeader("Connection", (Object)"TE");
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertNotNull((Object)request.getHeader("TE"));
        Assertions.assertEquals((Object)"trailers", (Object)request.getHeader("TE").getValue());
    }

    @Test
    void testMultipleValidTEHeaders() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers, deflate;q=0.5");
        request.setHeader("Connection", (Object)"TE");
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertNotNull((Object)request.getHeader("TE"));
        Assertions.assertEquals((Object)"trailers, deflate;q=0.5", (Object)request.getHeader("TE").getValue());
    }

    @Test
    void testTEHeaderNotPresent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertNull((Object)request.getHeader("TE"));
    }

    @Test
    void testTEHeaderContainsChunked() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"chunked");
        RequestTE interceptor = new RequestTE();
        Assertions.assertThrows(ProtocolException.class, () -> TestRequestTE.lambda$testTEHeaderContainsChunked$0((HttpRequestInterceptor)interceptor, request, context));
    }

    @Test
    void testTEHeaderInvalidTransferCoding() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"invalid;q=abc");
        RequestTE interceptor = new RequestTE();
        Assertions.assertThrows(ProtocolException.class, () -> TestRequestTE.lambda$testTEHeaderInvalidTransferCoding$1((HttpRequestInterceptor)interceptor, request, context));
    }

    @Test
    void testTEHeaderAlreadySet() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        String teValue = "trailers";
        request.setHeader("TE", (Object)"trailers");
        request.setHeader("Connection", (Object)"TE");
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"TE", (Object)request.getHeader("TE").getName());
        Assertions.assertNotNull((Object)request.getHeader("TE"));
        Assertions.assertEquals((Object)"trailers", (Object)request.getHeader("TE").getValue());
    }

    @Test
    void testTEHeaderWithConnectionHeaderValidation() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers");
        request.setHeader("Connection", (Object)"TE");
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"TE", (Object)request.getHeader("TE").getName());
        Assertions.assertNotNull((Object)request.getHeader("TE"));
        Assertions.assertEquals((Object)"trailers", (Object)request.getHeader("TE").getValue());
    }

    @Test
    void testTEHeaderWithoutConnectionHeaderThrowsException() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers");
        RequestTE interceptor = new RequestTE();
        Assertions.assertThrows(ProtocolException.class, () -> TestRequestTE.lambda$testTEHeaderWithoutConnectionHeaderThrowsException$2((HttpRequestInterceptor)interceptor, request, context));
    }

    @Test
    void testTEHeaderWithoutTEInConnectionHeaderThrowsException() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers");
        request.setHeader("Connection", (Object)"keep-alive");
        RequestTE interceptor = new RequestTE();
        Assertions.assertThrows(ProtocolException.class, () -> TestRequestTE.lambda$testTEHeaderWithoutTEInConnectionHeaderThrowsException$3((HttpRequestInterceptor)interceptor, request, context));
    }

    @Test
    void testTEHeaderWithMultipleDirectivesInConnectionHeader() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("TE", (Object)"trailers");
        request.setHeader("Connection", (Object)"keep-alive, close, TE");
        RequestTE interceptor = new RequestTE();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertNotNull((Object)request.getHeader("Connection"));
        Assertions.assertTrue((boolean)request.getHeader("Connection").getValue().contains("TE"));
    }

    private static /* synthetic */ void lambda$testTEHeaderWithoutTEInConnectionHeaderThrowsException$3(HttpRequestInterceptor interceptor, BasicClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testTEHeaderWithoutConnectionHeaderThrowsException$2(HttpRequestInterceptor interceptor, BasicClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testTEHeaderInvalidTransferCoding$1(HttpRequestInterceptor interceptor, BasicClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testTEHeaderContainsChunked$0(HttpRequestInterceptor interceptor, BasicClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }
}

