/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpCacheEntry
implements MessageHeaders,
Serializable {
    private static final long serialVersionUID = -6300496422359477413L;
    private final Instant requestDate;
    private final Instant responseDate;
    private final String method;
    private final String requestURI;
    private final HeaderGroup requestHeaders;
    private final int status;
    private final HeaderGroup responseHeaders;
    private final Resource resource;
    private final Set<String> variants;
    private final AtomicReference<Instant> dateRef;
    private final AtomicReference<Instant> expiresRef;
    private final AtomicReference<Instant> lastModifiedRef;
    private final AtomicReference<ETag> eTagRef;
    private static final Instant NON_VALUE = Instant.ofEpochSecond(Instant.MIN.getEpochSecond(), 0L);

    @Internal
    public HttpCacheEntry(Instant requestDate, Instant responseDate, String method, String requestURI, HeaderGroup requestHeaders, int status, HeaderGroup responseHeaders, Resource resource, Collection<String> variants) {
        this.requestDate = requestDate;
        this.responseDate = responseDate;
        this.method = method;
        this.requestURI = requestURI;
        this.requestHeaders = requestHeaders;
        this.status = status;
        this.responseHeaders = responseHeaders;
        this.resource = resource;
        this.variants = variants != null ? Collections.unmodifiableSet(new HashSet<String>(variants)) : null;
        this.dateRef = new AtomicReference();
        this.expiresRef = new AtomicReference();
        this.lastModifiedRef = new AtomicReference();
        this.eTagRef = new AtomicReference();
    }

    @Deprecated
    public HttpCacheEntry(Date requestDate, Date responseDate, int status, Header[] responseHeaders, Resource resource, Map<String, String> variantMap) {
        this(DateUtils.toInstant((Date)requestDate), DateUtils.toInstant((Date)responseDate), status, responseHeaders, resource, variantMap);
    }

    @Deprecated
    public HttpCacheEntry(Instant requestDate, Instant responseDate, int status, Header[] responseHeaders, Resource resource, Map<String, String> variantMap) {
        Args.notNull((Object)requestDate, (String)"Request date");
        Args.notNull((Object)responseDate, (String)"Response date");
        Args.check((status >= 200 ? 1 : 0) != 0, (String)"Status code");
        Args.notNull((Object)responseHeaders, (String)"Response headers");
        this.requestDate = requestDate;
        this.responseDate = responseDate;
        this.method = Method.GET.name();
        this.requestURI = "/";
        this.requestHeaders = new HeaderGroup();
        this.status = status;
        this.responseHeaders = new HeaderGroup();
        this.responseHeaders.setHeaders(responseHeaders);
        this.resource = resource;
        this.variants = variantMap != null ? Collections.unmodifiableSet(new HashSet<String>(variantMap.keySet())) : null;
        this.dateRef = new AtomicReference();
        this.expiresRef = new AtomicReference();
        this.lastModifiedRef = new AtomicReference();
        this.eTagRef = new AtomicReference();
    }

    @Deprecated
    public HttpCacheEntry(Date requestDate, Date responseDate, int status, Header[] responseHeaders, Resource resource) {
        this(requestDate, responseDate, status, responseHeaders, resource, new HashMap<String, String>());
    }

    @Deprecated
    public HttpCacheEntry(Instant requestDate, Instant responseDate, int status, Header[] responseHeaders, Resource resource) {
        this(requestDate, responseDate, status, responseHeaders, resource, new HashMap<String, String>());
    }

    public int getStatus() {
        return this.status;
    }

    @Deprecated
    public Date getRequestDate() {
        return DateUtils.toDate((Instant)this.requestDate);
    }

    public Instant getRequestInstant() {
        return this.requestDate;
    }

    @Deprecated
    public Date getResponseDate() {
        return DateUtils.toDate((Instant)this.responseDate);
    }

    public Instant getResponseInstant() {
        return this.responseDate;
    }

    public Header[] getHeaders() {
        return this.responseHeaders.getHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.responseHeaders.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.responseHeaders.getLastHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.responseHeaders.getHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this.responseHeaders.containsHeader(name);
    }

    public int countHeaders(String name) {
        return this.responseHeaders.countHeaders(name);
    }

    public Header getHeader(String name) throws ProtocolException {
        return this.responseHeaders.getHeader(name);
    }

    public Iterator<Header> headerIterator() {
        return this.responseHeaders.headerIterator();
    }

    public Iterator<Header> headerIterator(String name) {
        return this.responseHeaders.headerIterator(name);
    }

    public MessageHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public Date getDate() {
        return DateUtils.toDate((Instant)this.getInstant());
    }

    private Instant getInstant(AtomicReference<Instant> ref, String headerName) {
        Instant instant = ref.get();
        if (instant == null) {
            instant = DateUtils.parseStandardDate((MessageHeaders)this, (String)headerName);
            if (instant == null) {
                instant = NON_VALUE;
            }
            if (!ref.compareAndSet(null, instant)) {
                instant = ref.get();
            }
        }
        return instant != null && instant != NON_VALUE ? instant : null;
    }

    public Instant getInstant() {
        return this.getInstant(this.dateRef, "Date");
    }

    public Instant getExpires() {
        return this.getInstant(this.expiresRef, "Expires");
    }

    public Instant getLastModified() {
        return this.getInstant(this.lastModifiedRef, "Last-Modified");
    }

    public ETag getETag() {
        ETag eTag = this.eTagRef.get();
        if (eTag == null) {
            eTag = ETag.get((MessageHeaders)this);
            if (eTag == null) {
                return null;
            }
            if (!this.eTagRef.compareAndSet(null, eTag)) {
                eTag = this.eTagRef.get();
            }
        }
        return eTag;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasVariants() {
        return this.variants != null;
    }

    public Set<String> getVariants() {
        return this.variants != null ? this.variants : Collections.emptySet();
    }

    @Deprecated
    public Map<String, String> getVariantMap() {
        return this.variants != null ? this.variants.stream().collect(Collectors.toMap(Function.identity(), e -> e + this.requestURI)) : Collections.emptyMap();
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public MessageHeaders requestHeaders() {
        return this.requestHeaders;
    }

    public Iterator<Header> requestHeaderIterator() {
        return this.requestHeaders.headerIterator();
    }

    public Iterator<Header> requestHeaderIterator(String headerName) {
        return this.requestHeaders.headerIterator(headerName);
    }

    public static boolean isNewer(HttpCacheEntry entry, MessageHeaders message) {
        if (entry == null || message == null) {
            return false;
        }
        Instant cacheDate = entry.getInstant();
        if (cacheDate == null) {
            return false;
        }
        Instant messageDate = DateUtils.parseStandardDate((MessageHeaders)message, (String)"Date");
        if (messageDate == null) {
            return false;
        }
        return cacheDate.compareTo(messageDate) > 0;
    }

    public String toString() {
        return "HttpCacheEntry{requestDate=" + this.requestDate + ", responseDate=" + this.responseDate + ", method='" + this.method + '\'' + ", requestURI='" + this.requestURI + '\'' + ", requestHeaders=" + this.requestHeaders + ", status=" + this.status + ", responseHeaders=" + this.responseHeaders + ", resource=" + this.resource + ", variants=" + this.variants + '}';
    }
}

