/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

public enum SpecVersion {
    VERSION_1_0("1.0", "http://www.osgi.org/xmlns/scr/v1.0.0"),
    VERSION_1_1("1.1", "http://www.osgi.org/xmlns/scr/v1.1.0"),
    VERSION_1_1_FELIX("1.1_FELIX", "http://felix.apache.org/xmlns/scr/v1.1.0-felix"),
    VERSION_1_2("1.2", "http://www.osgi.org/xmlns/scr/v1.2.0");

    private final String name;
    private final String namespaceUrl;

    private SpecVersion(String name, String namespaceUrl) {
        this.name = name;
        this.namespaceUrl = namespaceUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUrl() {
        return this.namespaceUrl;
    }

    public static SpecVersion fromName(String n) {
        if (n == null) {
            return null;
        }
        try {
            return SpecVersion.valueOf(n.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (SpecVersion sv : SpecVersion.values()) {
                if (!sv.getName().equals(n)) continue;
                return sv;
            }
            return null;
        }
    }

    public static SpecVersion fromNamespaceUrl(String n) {
        if (n == null) {
            return null;
        }
        for (SpecVersion sv : SpecVersion.values()) {
            if (!sv.getNamespaceUrl().equals(n)) continue;
            return sv;
        }
        return null;
    }
}

