/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Arrays;
import java.util.Objects;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public final class ResourceInfo
extends WhiteboardServiceInfo<Object> {
    private final String[] patterns;
    private final String prefix;
    private final ServletInfo servletInfo;

    public ResourceInfo(ServiceReference<Object> ref) {
        super(ref);
        this.patterns = this.getStringArrayProperty(ref, "osgi.http.whiteboard.resource.pattern");
        this.prefix = this.getStringProperty(ref, "osgi.http.whiteboard.resource.prefix");
        this.servletInfo = new ResourceServletInfo(this);
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = super.isValid() && !this.isEmpty(this.patterns) && !this.isEmpty(this.prefix);
        if (valid) {
            for (String p : this.patterns) {
                if (PatternUtil.isValidPattern(p)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    @Override
    @NotNull
    public String getType() {
        return "Resource";
    }

    @Override
    public boolean isSame(AbstractInfo<Object> other) {
        if (!super.isSame(other)) {
            return false;
        }
        ResourceInfo o = (ResourceInfo)other;
        return Arrays.equals(this.patterns, o.patterns) && Objects.equals(this.prefix, o.prefix);
    }

    private static final class ResourceServletInfo
    extends ServletInfo {
        public ResourceServletInfo(ResourceInfo resource) {
            super(resource);
        }
    }
}

