/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.HeapUnionTest;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectUnionTest {
    @Test
    public void checkExactUnionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)512)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(512).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkEstUnionNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
    }

    @Test
    public void checkExactUnionWithOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate() / 2.0), (double)0.0);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)512)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(512).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkHeapifyExact() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)512)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(512).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
        ThetaUnion union2 = (ThetaUnion)ThetaSetOperation.heapify((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 512.0, 0.0);
    }

    @Test
    public void checkWrapExact() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)512)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(512).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 512.0, 0.0);
    }

    @Test
    public void checkWrapEstNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        CompactThetaSketch cosk2 = usk2.compact(true, null);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)cosk2);
        UpdatableThetaSketch emptySketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        union.union((ThetaSketch)emptySketch);
        emptySketch = null;
        union.union((ThetaSketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedDirectIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        MemorySegment cskSeg2 = MemorySegment.ofArray(new byte[usk2.getCompactBytes()]);
        CompactThetaSketch cosk2 = usk2.compact(true, cskSeg2);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)cosk2);
        UpdatableThetaSketch emptySketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        union.union((ThetaSketch)emptySketch);
        emptySketch = null;
        union.union((ThetaSketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedSegIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        MemorySegment cskSeg2 = MemorySegment.ofArray(new byte[usk2.getCompactBytes()]);
        usk2.compact(true, cskSeg2);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union(cskSeg2);
        UpdatableThetaSketch emptySketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        union.union((ThetaSketch)emptySketch);
        emptySketch = null;
        union.union((ThetaSketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapUnorderedSegIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        MemorySegment cskSeg2 = MemorySegment.ofArray(new byte[usk2.getCompactBytes()]);
        usk2.compact(false, cskSeg2);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union(cskSeg2);
        UpdatableThetaSketch emptySketch = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        union.union((ThetaSketch)emptySketch);
        emptySketch = null;
        union.union((ThetaSketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        ThetaUnion union2 = ThetaUnion.wrap((MemorySegment)MemorySegment.ofArray(union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkMultiUnion() {
        int i;
        int lgK = 13;
        int k = 8192;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        UpdatableThetaSketch usk3 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        UpdatableThetaSketch usk4 = UpdatableThetaSketch.builder().setNominalEntries(8192).build();
        int v = 0;
        int u = 1000000;
        for (i = 0; i < u; ++i) {
            usk1.update((long)(i + v));
        }
        v += u;
        u = 26797;
        for (i = 0; i < u; ++i) {
            usk2.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk3.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk4.update((long)(i + v));
        }
        v += u;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)8192)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(8192).buildUnion(uSeg);
        union.union((ThetaSketch)usk1);
        union.union((ThetaSketch)usk2);
        union.union((ThetaSketch)usk3);
        union.union((ThetaSketch)usk4);
        CompactThetaSketch csk = union.getResult(true, null);
        double est = csk.getEstimate();
        Assert.assertEquals((double)est, (double)v, (double)(0.01 * (double)v));
    }

    @Test
    public void checkDirectSegmentIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        MemorySegment skSeg1 = MemorySegment.ofArray(usk1.compact(false, null).toByteArray()).asReadOnly();
        MemorySegment skSeg2 = MemorySegment.ofArray(usk2.compact(true, null).toByteArray()).asReadOnly();
        CompactThetaSketch csk1 = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)skSeg1);
        CompactThetaSketch csk2 = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)skSeg2);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)csk1);
        union.union((ThetaSketch)csk2);
        CompactThetaSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkUpdateSegmentSpecialCases2() {
        int lgK = 12;
        int k = 4096;
        int u = 8192;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        for (int i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        CompactThetaSketch usk1c = usk1.compact(true, null);
        MemorySegment v3seg1 = MemorySegment.ofArray(usk1c.toByteArray());
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union(v3seg1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegBadSerVer() {
        int lgK = 12;
        int k = 4096;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build();
        usk1.update(1L);
        usk1.update(2L);
        CompactThetaSketch usk1c = usk1.compact(true, null);
        MemorySegment v3seg1 = MemorySegment.ofArray(usk1c.toByteArray());
        v3seg1.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union(v3seg1);
    }

    @Test
    public void checkDirectWrap() {
        int nomEntries = 16;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)16)]);
        ThetaSetOperation.builder().setNominalEntries(16).buildUnion(uSeg);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        sk1.update("a");
        sk1.update("b");
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        sk2.update("c");
        sk2.update("d");
        ThetaUnion union = ThetaUnion.wrap((MemorySegment)uSeg);
        union.union((ThetaSketch)sk1);
        union = ThetaUnion.wrap((MemorySegment)uSeg);
        union.union((ThetaSketch)sk2);
        CompactThetaSketch sketch = union.getResult(true, null);
        Assert.assertEquals((double)4.0, (double)sketch.getEstimate(), (double)0.0);
    }

    @Test
    public void checkEmptyUnionCompactResult() {
        int k = 64;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)64)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(64).buildUnion(uSeg);
        MemorySegment seg = MemorySegment.ofArray(new byte[ThetaSketch.getMaxCompactSketchBytes((int)0)]);
        CompactThetaSketch csk = union.getResult(false, seg);
        Assert.assertTrue((boolean)csk.isEmpty());
    }

    @Test
    public void checkEmptyUnionCompactOrderedResult() {
        int k = 64;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)64)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(64).buildUnion(uSeg);
        MemorySegment seg = MemorySegment.ofArray(new byte[ThetaSketch.getMaxCompactSketchBytes((int)0)]);
        CompactThetaSketch csk = union.getResult(true, seg);
        Assert.assertTrue((boolean)csk.isEmpty());
    }

    @Test
    public void checkUnionSegToString() {
        int k = 64;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)64)]);
        ThetaSetOperation.builder().setNominalEntries(64).buildUnion(uSeg);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        int segBytes = ThetaSetOperation.getMaxUnionBytes((int)1024);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(1024).buildUnion(iSeg);
        union.union((ThetaSketch)sk);
        CompactThetaSketch csk = union.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkPrimitiveUpdates() {
        int k = 32;
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)32)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(32).buildUnion(uSeg);
        union.update(1L);
        union.update(1.5);
        union.update(0.0);
        union.update(-0.0);
        String s = null;
        union.update(s);
        s = "";
        union.update(s);
        s = "String";
        union.update(s);
        byte[] byteArr = null;
        union.update(byteArr);
        byteArr = new byte[]{};
        union.update(byteArr);
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        union.update(byteArr);
        union.update(ByteBuffer.wrap(byteArr));
        union.update(ByteBuffer.wrap(byteArr, 0, 4));
        int[] intArr = null;
        union.update(intArr);
        intArr = new int[]{};
        union.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        union.update(intArr2);
        long[] longArr = null;
        union.update(longArr);
        longArr = new long[]{};
        union.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        union.update(longArr2);
        CompactThetaSketch comp = union.getResult();
        double est = comp.getEstimate();
        boolean empty = comp.isEmpty();
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
        Assert.assertFalse((boolean)empty);
    }

    @Test
    public void checkGetFamily() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[288]);
        ThetaSetOperation setOp = new ThetaSetOperationBuilder().setNominalEntries(16).build(Family.UNION, seg);
        Assert.assertEquals((Object)setOp.getFamily(), (Object)Family.UNION);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreambleLongsCorruption() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[288]);
        ThetaSetOperation setOp = new ThetaSetOperationBuilder().setNominalEntries(16).build(Family.UNION, seg);
        DirectUnionTest.println(setOp.toString());
        int familyID = PreambleUtil.extractFamilyID((MemorySegment)seg);
        int preLongs = ThetaSketch.getPreambleLongs((MemorySegment)seg);
        Assert.assertEquals((int)familyID, (int)Family.UNION.getID());
        Assert.assertEquals((int)preLongs, (int)Family.UNION.getMaxPreLongs());
        PreambleUtil.insertPreLongs((MemorySegment)seg, (int)3);
        DirectQuickSelectSketch.writableWrap((MemorySegment)seg, null, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizeTooSmall() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[288]);
        ThetaSetOperation setOp = new ThetaSetOperationBuilder().setNominalEntries(16).build(Family.UNION, seg);
        DirectUnionTest.println(setOp.toString());
        MemorySegment seg2 = MemorySegment.ofArray(new byte[32]);
        MemorySegment.copy(seg, 0L, seg2, 0L, 32L);
        DirectQuickSelectSketch.writableWrap((MemorySegment)seg2, null, (long)9001L);
    }

    @Test
    public void checkForDruidBug() {
        int k = 16384;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(16384).build();
        for (int i = 0; i < 100000; ++i) {
            usk.update(Integer.toString(i));
        }
        usk.rebuild();
        CompactThetaSketch s = usk.compact();
        MemorySegment seg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)16384)]);
        ThetaUnion union1 = ThetaSetOperation.builder().setNominalEntries(16384).buildUnion(seg);
        union1.union((ThetaSketch)s);
        CompactThetaSketch csk = union1.getResult();
        Assert.assertTrue((csk.getTheta() < 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16384);
        double est = csk.getEstimate();
        Assert.assertTrue((est > 98663.0 ? 1 : 0) != 0);
        Assert.assertTrue((est < 101530.0 ? 1 : 0) != 0);
    }

    @Test
    public void checkForDruidBug2() {
        int k = 16384;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(16384).build();
        for (int i = 0; i < 100000; ++i) {
            usk.update(Integer.toString(i));
        }
        usk.rebuild();
        MemorySegment segIn = MemorySegment.ofArray(new byte[usk.getCompactBytes()]);
        usk.compact(true, segIn);
        MemorySegment seg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)16384)]);
        ThetaUnion union1 = ThetaSetOperation.builder().setNominalEntries(16384).buildUnion(seg);
        union1.union(segIn);
        CompactThetaSketch csk = union1.getResult();
        Assert.assertTrue((csk.getTheta() < 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk.getRetainedEntries(true), (int)16384);
        double est = csk.getEstimate();
        Assert.assertTrue((est > 98663.0 ? 1 : 0) != 0);
        Assert.assertTrue((est < 101530.0 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        DirectUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

