/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.group.impl;

import org.apache.activemq.artemis.api.core.SimpleString;

public class GroupBinding {
    private long id;
    private final SimpleString groupId;
    private final SimpleString clusterName;
    volatile long timeUsed;

    public GroupBinding(SimpleString groupId, SimpleString clusterName) {
        this.groupId = groupId;
        this.clusterName = clusterName;
        this.use();
    }

    public GroupBinding(long id, SimpleString groupId, SimpleString clusterName) {
        this.id = id;
        this.groupId = groupId;
        this.clusterName = clusterName;
        this.use();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public SimpleString getGroupId() {
        return this.groupId;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public long getTimeUsed() {
        return this.timeUsed;
    }

    public void use() {
        this.timeUsed = System.currentTimeMillis();
    }

    public String toString() {
        return this.id + ":" + String.valueOf(this.groupId) + ":" + String.valueOf(this.clusterName);
    }
}

