/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;

public class SessionSendMessage_V2
extends SessionSendMessage {
    private long correlationID;

    public SessionSendMessage_V2(ICoreMessage message, boolean requiresResponse, SendAcknowledgementHandler handler) {
        super((byte)71, message, requiresResponse, handler);
    }

    public SessionSendMessage_V2(CoreMessage message) {
        super((byte)71, message);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readLong();
    }

    @Override
    protected int fieldsEncodeSize() {
        return super.fieldsEncodeSize() + 8;
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void setCorrelationID(long correlationID) {
        this.correlationID = correlationID;
    }

    @Override
    public boolean isResponseAsync() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.correlationID ^ this.correlationID >>> 32);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", correlationID=" + this.correlationID);
        buff.append(", requiresResponse=" + super.isRequiresResponse());
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendMessage_V2)) {
            return false;
        }
        SessionSendMessage_V2 other = (SessionSendMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

