/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileAttributes;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProvider;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class HdfsFileProviderTest {
    private static final int PORT = 8620;
    private static final String HDFS_URI = "hdfs://localhost:8620";
    private static final String TEST_DIR1 = "hdfs://localhost:8620/test-dir";
    private static final Path DIR1_PATH;
    private static final String TEST_FILE1 = "hdfs://localhost:8620/test-dir/accumulo-test-1.jar";
    private static final Path FILE1_PATH;
    private static DefaultFileSystemManager manager;
    private static FileSystem hdfs;
    protected static Configuration conf;
    protected static MiniDFSCluster cluster;

    public static void setUmask(Configuration config) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            Process p = Runtime.getRuntime().exec("/bin/sh -c umask");
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = bri.readLine();
            p.waitFor();
            Short umask = Short.parseShort(line.trim(), 8);
            int newPermission = 0x1FF ^ umask;
            config.set("dfs.datanode.data.dir.perm", String.format("%03o", newPermission));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error getting umask from O/S", e);
        }
    }

    @BeforeAll
    public static void setUp() throws Exception {
        System.setProperty("test.basedir", "../commons-vfs2/target/test-classes/test-data");
        Logger.getRootLogger().setLevel(Level.ERROR);
        File data = new File("target/test/hdfstestdata").getAbsoluteFile();
        data.mkdirs();
        System.setProperty("test.build.data", data.toString());
        FileUtils.cleanDirectory((File)data);
        conf = new Configuration();
        conf.set("fs.defaultFS", HDFS_URI);
        conf.set("hadoop.security.token.service.use_ip", "true");
        conf.setLong("dfs.blocksize", 0x100000L);
        HdfsFileProviderTest.setUmask(conf);
        cluster = new MiniDFSCluster.Builder(conf).nameNodePort(8620).numDataNodes(1).build();
        cluster.waitActive();
        manager = new DefaultFileSystemManager();
        manager.addProvider("hdfs", (FileProvider)new HdfsFileProvider());
        manager.init();
        hdfs = cluster.getFileSystem();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (null != hdfs) {
            hdfs.close();
        }
        manager.close();
    }

    @AfterEach
    public void after() throws Exception {
        if (null != hdfs) {
            hdfs.delete(DIR1_PATH, true);
        }
    }

    private FileObject createTestFile(FileSystem hdfs) throws IOException {
        hdfs.mkdirs(DIR1_PATH);
        FileObject dir = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
        Assertions.assertEquals((Object)dir.getType(), (Object)FileType.FOLDER);
        hdfs.create(FILE1_PATH).close();
        FileObject f = manager.resolveFile(TEST_FILE1);
        Assertions.assertNotNull((Object)f);
        Assertions.assertTrue((boolean)f.exists());
        Assertions.assertEquals((Object)f.getType(), (Object)FileType.FILE);
        return f;
    }

    @Test
    public void testCanRenameTo() throws Exception {
        FileObject fo = this.createTestFile(hdfs);
        Assertions.assertNotNull((Object)fo);
        fo.canRenameTo(fo);
    }

    @Test
    public void testDoListChildren() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        FileObject dir = file.getParent();
        FileObject[] children = dir.getChildren();
        Assertions.assertEquals((int)1, (int)children.length);
        Assertions.assertEquals((Object)children[0].getName(), (Object)file.getName());
    }

    @Test
    public void testEquals() throws Exception {
        FileObject dir = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)dir);
        Assertions.assertFalse((boolean)dir.exists());
        FileObject file1 = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)file1.exists());
        Assertions.assertTrue((boolean)dir.exists());
        FileObject file2 = manager.resolveFile(TEST_FILE1);
        Assertions.assertEquals((Object)file1, (Object)file2);
        Assertions.assertNotEquals((Object)dir, (Object)file1);
        Assertions.assertNotEquals((Object)dir, (Object)file2);
    }

    @Test
    public void testGetAttributes() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Map attributes = file.getContent().getAttributes();
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.BLOCK_SIZE.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.GROUP.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.LAST_ACCESS_TIME.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.LENGTH.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.MODIFICATION_TIME.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.OWNER.toString()));
        Assertions.assertTrue((boolean)attributes.containsKey(HdfsFileAttributes.PERMISSIONS.toString()));
    }

    @Test
    public void testGetContentSize() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertEquals((long)0L, (long)file.getContent().getSize());
        Assertions.assertTrue((boolean)file.getContent().isEmpty());
    }

    @Test
    public void testGetInputStream() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        file.getContent().getInputStream().close();
    }

    @Test
    public void testInit() throws Exception {
        FileObject fo = manager.resolveFile(TEST_FILE1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
    }

    @Test
    public void testIsHidden() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertFalse((boolean)file.isHidden());
    }

    @Test
    public void testIsReadable() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertTrue((boolean)file.isReadable());
    }

    @Test
    public void testIsWritable() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertTrue((boolean)file.isWriteable());
    }

    @Test
    public void testLastModificationTime() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertNotEquals((long)-1L, (long)file.getContent().getLastModifiedTime());
    }

    @Test
    public void testRandomAccessContent() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        Assertions.assertThrows(FileSystemException.class, () -> file.getContent().getRandomAccessContent(RandomAccessMode.READWRITE).close());
    }

    @Test
    public void testRandomAccessContent2() throws Exception {
        FileObject fo = manager.resolveFile(TEST_DIR1);
        Assertions.assertNotNull((Object)fo);
        Assertions.assertFalse((boolean)fo.exists());
        FileObject file = this.createTestFile(hdfs);
        Assertions.assertTrue((boolean)fo.exists());
        file.getContent().getRandomAccessContent(RandomAccessMode.READ).close();
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        DIR1_PATH = new Path("/test-dir");
        FILE1_PATH = new Path(DIR1_PATH, "accumulo-test-1.jar");
    }
}

