/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.function.VfsConsumer;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira733Test {
    @AfterEach
    @BeforeEach
    public void reset() throws FileSystemException {
        VFS.reset();
    }

    @Test
    public void testZipParentLayer() throws Exception {
        File file = new File("src/test/resources/test-data/test.zip");
        String nestedPath = "zip:" + file.getAbsolutePath() + "!/read-tests/file1.txt";
        try (FileObject fileObject = VFS.getManager().resolveFile(nestedPath);
             OnCallRefreshFileObject wrappedFileObject = new OnCallRefreshFileObject(fileObject);){
            Assertions.assertNotNull((Object)wrappedFileObject.getFileSystem().getParentLayer(), (String)"getParentLayer() 1");
            wrappedFileObject.exists();
            wrappedFileObject.getContent();
            Assertions.assertNotNull((Object)wrappedFileObject.getFileSystem().getParentLayer(), (String)"getParentLayer() 2");
        }
    }

    private void testZipParentLayer(VfsConsumer<FileObject> consumer) throws Exception {
        File file = new File("src/test/resources/test-data/test.zip");
        Assertions.assertTrue((boolean)file.exists());
        String nestedPath = "zip:" + file.getAbsolutePath() + "!/read-tests/file1.txt";
        try (FileObject fileObject = VFS.getManager().resolveFile(nestedPath);
             OnCallRefreshFileObject wrappedFileObject = new OnCallRefreshFileObject(fileObject);){
            Assertions.assertInstanceOf(ZipFileObject.class, (Object)fileObject);
            ZipFileObject zipFileObject = (ZipFileObject)fileObject;
            Assertions.assertNotNull((Object)wrappedFileObject.getFileSystem().getParentLayer(), (String)"getParentLayer() 1");
            consumer.accept((Object)wrappedFileObject);
            Assertions.assertNotNull((Object)wrappedFileObject.getFileSystem().getParentLayer(), (String)"getParentLayer() 2");
        }
    }

    @Test
    public void testZipParentLayerExists() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::exists));
    }

    @Test
    public void testZipParentLayerExistsGetContents() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)fileObject -> {
            fileObject.exists();
            fileObject.getContent();
        }));
    }

    @Test
    public void testZipParentLayerGetChildren() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)fileObject -> fileObject.getParent().getChildren()));
    }

    @Test
    public void testZipParentLayerGetContents() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::getContent));
    }

    @Test
    public void testZipParentLayerGetType() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::getType));
    }

    @Test
    public void testZipParentLayerIsAttached() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isAttached));
    }

    @Test
    public void testZipParentLayerIsContentOpen() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isContentOpen));
    }

    @Test
    public void testZipParentLayerIsExecutable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isExecutable));
    }

    @Test
    public void testZipParentLayerIsFile() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isFile));
    }

    @Test
    public void testZipParentLayerIsFolder() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isFolder));
    }

    @Test
    public void testZipParentLayerIsHidden() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isHidden));
    }

    @Test
    public void testZipParentLayerIsReadable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isReadable));
    }

    @Test
    public void testZipParentLayerIsWriteable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isWriteable));
    }
}

