/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FileObjectSortTest {
    private static final int SIZE = 100;
    private static FileSystem vfsFileSystem;
    private static FileObject[] sortedArray;
    private static FileObject[] unSortedArray;

    private static FileObject resolveFile(FileSystem fs, int i) throws FileSystemException {
        return fs.resolveFile(String.format("%010d", i));
    }

    @BeforeAll
    public static void setUpClass() throws FileSystemException {
        int i;
        vfsFileSystem = VFS.getManager().createVirtualFileSystem("vfs://").getFileSystem();
        sortedArray = new FileObject[100];
        for (i = 0; i < 100; ++i) {
            FileObjectSortTest.sortedArray[i] = FileObjectSortTest.resolveFile(vfsFileSystem, i);
        }
        unSortedArray = new FileObject[100];
        for (i = 0; i < 100; ++i) {
            FileObjectSortTest.unSortedArray[i] = FileObjectSortTest.resolveFile(vfsFileSystem, 100 - i - 1);
        }
    }

    @Test
    public void testSortArrayIgnoreCase() throws FileSystemException {
        FileObject file1 = vfsFileSystem.resolveFile("A1");
        FileObject file2 = vfsFileSystem.resolveFile("a2");
        FileObject file3 = vfsFileSystem.resolveFile("A3");
        Object[] actualArray = new FileObject[]{file3, file1, file2, file1, file2};
        Object[] expectedArray = new FileObject[]{file1, file1, file2, file2, file3};
        Arrays.sort(actualArray);
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])actualArray);
    }

    @Test
    public void testSortArrayMoveAll() {
        Object[] actualArray = (FileObject[])unSortedArray.clone();
        Assertions.assertFalse((boolean)Arrays.equals(unSortedArray, sortedArray));
        Arrays.sort(actualArray);
        Assertions.assertArrayEquals((Object[])sortedArray, (Object[])actualArray);
    }

    @Test
    public void testSortArrayMoveNone() {
        Object[] actualArray = (FileObject[])sortedArray.clone();
        Arrays.sort(actualArray);
        Assertions.assertArrayEquals((Object[])sortedArray, (Object[])actualArray);
    }

    @Test
    public void testSortListMoveAll() {
        List<FileObject> actualList = Arrays.asList(unSortedArray);
        List<FileObject> expectedSortedList = Arrays.asList(sortedArray);
        Assertions.assertNotEquals(actualList, expectedSortedList);
        actualList.sort(null);
        Assertions.assertEquals(actualList, expectedSortedList);
    }

    @Test
    public void testSortListMoveNone() {
        List<FileObject> actualList = Arrays.asList(sortedArray);
        List<FileObject> expectedSortedList = Arrays.asList(sortedArray);
        actualList.sort(null);
        Assertions.assertEquals(actualList, expectedSortedList);
    }
}

