/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.Test;

public class SftpMultiThreadWriteTests
extends AbstractProviderTestCase {
    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelCopyFromLocalFileSystem() throws Exception {
        File localFile = new File("src/test/resources/test-data/test.zip");
        FileObject localFileObject = VFS.getManager().toFileObject(localFile);
        FileObject scratchFolder = this.createScratchFolder();
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        for (int i = 0; i < 100; ++i) {
            String fileName = "file" + i + "copy.txt";
            tasks.add(() -> {
                try {
                    FileObject fileObjectCopy = scratchFolder.resolveFile(fileName);
                    SftpMultiThreadWriteTests.assertFalse((boolean)fileObjectCopy.exists());
                    fileObjectCopy.copyFrom(localFileObject, Selectors.SELECT_SELF);
                }
                catch (Throwable e) {
                    return false;
                }
                return true;
            });
        }
        ExecutorService service = Executors.newFixedThreadPool(10);
        try {
            List futures = service.invokeAll(tasks);
            SftpMultiThreadWriteTests.assertTrue((boolean)futures.stream().allMatch(future -> {
                try {
                    return (Boolean)future.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    return false;
                }
            }));
        }
        finally {
            service.shutdown();
        }
    }
}

