/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.net.URI;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.junit.Test;

public class UriTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.URI};
    }

    @Test
    public void testAbsoluteURI() throws Exception {
        FileObject readFolder = this.getReadFolder();
        String uri = readFolder.getName().getURI();
        FileObject file = this.getManager().resolveFile(uri, readFolder.getFileSystem().getFileSystemOptions());
        UriTests.assertEquals((boolean)readFolder.exists(), (boolean)file.exists());
        UriTests.assertEquals((Object)readFolder.getName(), (Object)file.getName());
        UriTests.assertEquals((String)readFolder.getPublicURIString(), (String)file.getPublicURIString());
        UriTests.assertEquals((Object)readFolder.getType(), (Object)file.getType());
        UriTests.assertEquals((Object)readFolder.getURI(), (Object)file.getURI());
        UriTests.assertEquals((Object)readFolder.getURL(), (Object)file.getURL());
        UriTests.assertEquals((boolean)readFolder.isAttached(), (boolean)file.isAttached());
        UriTests.assertEquals((boolean)readFolder.isContentOpen(), (boolean)file.isContentOpen());
        UriTests.assertEquals((boolean)readFolder.isExecutable(), (boolean)file.isExecutable());
        UriTests.assertEquals((boolean)readFolder.isFile(), (boolean)file.isFile());
        UriTests.assertEquals((boolean)readFolder.isFolder(), (boolean)file.isFolder());
        UriTests.assertEquals((boolean)readFolder.isHidden(), (boolean)file.isHidden());
        UriTests.assertEquals((boolean)readFolder.isReadable(), (boolean)file.isReadable());
        UriTests.assertEquals((boolean)readFolder.isSymbolicLink(), (boolean)file.isSymbolicLink());
        UriTests.assertEquals((boolean)readFolder.isWriteable(), (boolean)file.isWriteable());
        UriTests.assertEquals((String)readFolder.toString(), (String)file.toString());
        UriTests.assertEquals((String)String.format("file object %s %s, %s %s", readFolder.getClass(), ObjectUtils.identityHashCodeHex((Object)readFolder), file.getClass(), ObjectUtils.identityHashCodeHex((Object)file)), (String)readFolder.toString(), (String)file.toString());
        String rootUri = readFolder.getName().getRootURI();
        file = this.getManager().resolveFile(rootUri, readFolder.getFileSystem().getFileSystemOptions());
        UriTests.assertEquals((String)readFolder.getFileSystem().getRoot().toString(), (String)file.toString());
        UriTests.assertEquals((String)rootUri, (String)file.getName().getRootURI());
        UriTests.assertEquals((String)rootUri, (String)file.getName().getURI());
        UriTests.assertEquals((String)"/", (String)file.getName().getPath());
    }

    @Test
    public void testGetURI() throws Exception {
        FileObject fileObject = this.getReadFolder().resolveFile("some-dir/");
        URI uri = fileObject.getURI();
        UriTests.assertEquals((String)fileObject.getName().getURI(), (String)uri.toString());
        UriTests.assertEquals((Object)URI.create(fileObject.getName().getURI()), (Object)uri);
        UriTests.assertEquals((String)fileObject.getURL().toString(), (String)fileObject.getURI().toString());
        UriTests.assertEquals((Object)fileObject.getURL().toURI(), (Object)fileObject.getURI());
    }

    @Test
    public void testReservedCharacterSpace() throws FileSystemException {
        String string;
        URI url;
        try (FileObject fileObject = this.getReadFolder().resolveFile("file with spaces.txt");){
            url = fileObject.getURI();
            string = url.toString();
            UriTests.assertTrue((String)string, (boolean)string.contains("file%20with%20spaces.txt"));
        }
        fileObject = this.getReadFolder().resolveFile("file%20with%20spaces.txt");
        try {
            url = fileObject.getURI();
            string = url.toString();
            UriTests.assertTrue((String)string, (boolean)string.contains("file%20with%20spaces.txt"));
        }
        finally {
            if (fileObject != null) {
                fileObject.close();
            }
        }
    }

    @Test
    public void testURIContentProvider() throws Exception {
        FileObject fileObject = this.getReadFolder().resolveFile("file1.txt");
        UriTests.assertTrue((boolean)fileObject.exists());
        URI uri = fileObject.getURI();
        String uriStr = uri.toString();
        FileSystemOptions options = this.getReadFolder().getFileSystem().getFileSystemOptions();
        FileObject f1 = this.getManager().resolveFile(uriStr, options);
        FileObject f2 = this.getManager().resolveFile(uriStr, options);
        UriTests.assertEquals((String)("Two files resolved by URI must be equals on " + uriStr), (Object)f1, (Object)f2);
        UriTests.assertSame((String)("Resolving two times should not produce new filesystem on " + uriStr), (Object)f1.getFileSystem(), (Object)f2.getFileSystem());
    }
}

