/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import java.util.Objects;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class Webdav4FileContentInfoFactory
implements FileContentInfoFactory {
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        Webdav4FileObject file = (Webdav4FileObject)FileObjectUtils.getAbstractFileObject((FileObject)fileContent.getFile());
        String contentType = null;
        String contentEncoding = null;
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.GETCONTENTTYPE);
        DavPropertySet propertySet = file.getProperties((GenericURLFileName)file.getName(), nameSet, true);
        DavProperty property = propertySet.get(DavPropertyName.GETCONTENTTYPE);
        if (property != null) {
            contentType = Objects.toString(property.getValue(), null);
        }
        if ((property = propertySet.get(Webdav4FileObject.RESPONSE_CHARSET)) != null) {
            contentEncoding = Objects.toString(property.getValue(), null);
        }
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

