/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttributeIterator
implements NodeIterator {
    private final NodePointer parent;
    private final QName qName;
    private final List<Attr> attributes;
    private int position;

    public DOMAttributeIterator(NodePointer parent, QName qName) {
        this.parent = parent;
        this.qName = qName;
        this.attributes = new ArrayList<Attr>();
        Node node = (Node)parent.getNode();
        if (node.getNodeType() == 1) {
            String lname = qName.getName();
            if (!lname.equals("*")) {
                Attr attr = this.getAttribute((Element)node, qName);
                if (attr != null) {
                    this.attributes.add(attr);
                }
            } else {
                NamedNodeMap map = node.getAttributes();
                int count = map.getLength();
                for (int i = 0; i < count; ++i) {
                    Attr attr = (Attr)map.item(i);
                    if (!this.testAttr(attr)) continue;
                    this.attributes.add(attr);
                }
            }
        }
    }

    private Attr getAttribute(Element element, QName qName) {
        String testPrefix = qName.getPrefix();
        String testNS = null;
        if (testPrefix != null) {
            testNS = this.parent.getNamespaceResolver().getNamespaceURI(testPrefix);
        }
        if (testNS != null) {
            Attr attr = element.getAttributeNodeNS(testNS, qName.getName());
            if (attr != null) {
                return attr;
            }
            NamedNodeMap nnm = element.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                attr = (Attr)nnm.item(i);
                if (!this.testAttr(attr)) continue;
                return attr;
            }
            return null;
        }
        return element.getAttributeNode(qName.getName());
    }

    @Override
    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new DOMAttributePointer(this.parent, this.attributes.get(index));
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }

    private boolean testAttr(Attr attr) {
        String nodePrefix = DOMNodePointer.getPrefix(attr);
        String nodeLocalName = DOMNodePointer.getLocalName(attr);
        if (nodePrefix != null && nodePrefix.equals("xmlns")) {
            return false;
        }
        if (nodePrefix == null && nodeLocalName.equals("xmlns")) {
            return false;
        }
        String testLocalName = this.qName.getName();
        if (testLocalName.equals("*") || testLocalName.equals(nodeLocalName)) {
            String testPrefix = this.qName.getPrefix();
            if (testPrefix == null || Objects.equals(testPrefix, nodePrefix)) {
                return true;
            }
            if (nodePrefix == null) {
                return false;
            }
            return Objects.equals(this.parent.getNamespaceURI(testPrefix), this.parent.getNamespaceURI(nodePrefix));
        }
        return false;
    }
}

