/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

public class DeferrableOutputStream
extends OutputStream {
    private final int threshold;
    private final long longThreshold;
    private final Supplier<Path> pathSupplier;
    private Path path;
    private ByteArrayOutputStream baos;
    private byte[] bytes;
    private OutputStream out;
    private State state;
    private boolean wasPersisted;
    private long size;
    private final Listener listener;

    public DeferrableOutputStream(int threshold, Supplier<Path> pathSupplier, Listener listener) throws IOException {
        this.threshold = threshold < 0 ? -1 : threshold;
        this.longThreshold = threshold;
        this.pathSupplier = pathSupplier;
        this.listener = listener;
        this.checkThreshold(0);
    }

    protected OutputStream checkThreshold(int numberOfIncomingBytes) throws IOException {
        if (this.state == null) {
            if (this.threshold == -1) {
                return this.persist();
            }
            this.baos = new ByteArrayOutputStream();
            this.bytes = null;
            this.state = State.initialized;
            return this.baos;
        }
        switch (this.state) {
            case initialized: 
            case opened: {
                int bytesWritten = this.baos.size();
                if ((long)bytesWritten + (long)numberOfIncomingBytes >= this.longThreshold) {
                    return this.persist();
                }
                if (numberOfIncomingBytes > 0) {
                    this.state = State.opened;
                }
                return this.baos;
            }
            case persisted: {
                return this.out;
            }
            case closed: {
                return null;
            }
        }
        throw this.illegalStateError();
    }

    @Override
    public void close() throws IOException {
        switch (this.state) {
            case initialized: 
            case opened: {
                this.bytes = this.baos.toByteArray();
                this.baos = null;
                this.state = State.closed;
                break;
            }
            case persisted: {
                this.bytes = null;
                this.out.close();
                this.state = State.closed;
                break;
            }
            case closed: {
                break;
            }
            default: {
                throw this.illegalStateError();
            }
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        if (this.state == State.closed) {
            if (this.bytes != null) {
                return new ByteArrayInputStream(this.bytes);
            }
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        throw new IllegalStateException("This stream isn't yet closed.");
    }

    public Path getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public State getState() {
        return this.state;
    }

    public int getThreshold() {
        return this.threshold;
    }

    private IllegalStateException illegalStateError() {
        throw new IllegalStateException("Expected state initialized|opened|persisted|closed, got " + this.state.name());
    }

    public boolean isInMemory() {
        switch (this.state) {
            case initialized: 
            case opened: {
                return true;
            }
            case persisted: {
                return false;
            }
            case closed: {
                return !this.wasPersisted;
            }
        }
        throw this.illegalStateError();
    }

    protected OutputStream persist() throws IOException {
        Path p = this.pathSupplier.get();
        Path dir = p.getParent();
        if (dir != null) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        OutputStream os = Files.newOutputStream(p, new OpenOption[0]);
        if (this.baos != null) {
            this.baos.writeTo(os);
        }
        this.state = State.persisted;
        this.wasPersisted = true;
        this.path = p;
        this.out = os;
        this.baos = null;
        this.bytes = null;
        if (this.listener != null) {
            this.listener.persisted(p);
        }
        return os;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (len > 0) {
            OutputStream os = this.checkThreshold(len);
            if (os == null) {
                throw new IOException("This stream has already been closed.");
            }
            this.bytes = null;
            os.write(buffer, offset, len);
            this.size += (long)len;
        }
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream os = this.checkThreshold(1);
        if (os == null) {
            throw new IOException("This stream has already been closed.");
        }
        this.bytes = null;
        os.write(b);
        ++this.size;
    }

    public static interface Listener {
        default public void persisted(Path path) {
        }
    }

    public static enum State {
        initialized,
        opened,
        persisted,
        closed;

    }
}

