/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteUtilsTest {
    ByteUtilsTest() {
    }

    @Test
    void testFromLittleEndianFromArray() {
        byte[] b = new byte[]{1, 2, 3, 4, 5};
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)3));
    }

    @Test
    void testFromLittleEndianFromArrayOneArg() {
        byte[] b = new byte[]{2, 3, 4};
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test
    void testFromLittleEndianFromArrayOneArgThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}));
    }

    @Test
    void testFromLittleEndianFromArrayOneArgUnsignedInt32() {
        byte[] b = new byte[]{2, 3, 4, -128};
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test
    void testFromLittleEndianFromArrayThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (int)0, (int)9));
    }

    @Test
    void testFromLittleEndianFromArrayUnsignedInt32() {
        byte[] b = new byte[]{1, 2, 3, 4, -128};
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)4));
    }

    @Test
    void testFromLittleEndianFromDataInput() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, 5}));
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)3));
    }

    @Test
    void testFromLittleEndianFromDataInputThrowsForLengthTooBig() {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((DataInput)din, (int)9));
    }

    @Test
    void testFromLittleEndianFromDataInputThrowsForPrematureEnd() {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3}));
        Assertions.assertThrows(EOFException.class, () -> ByteUtils.fromLittleEndian((DataInput)din, (int)3));
    }

    @Test
    void testFromLittleEndianFromDataInputUnsignedInt32() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, -128}));
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)4));
    }

    @Test
    void testFromLittleEndianFromStream() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)3));
    }

    @Test
    void testFromLittleEndianFromStreamThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (int)9));
    }

    @Test
    void testFromLittleEndianFromStreamThrowsForPrematureEnd() {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertThrows(IOException.class, () -> ByteUtils.fromLittleEndian((InputStream)bin, (int)3));
    }

    @Test
    void testFromLittleEndianFromStreamUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)4));
    }

    @Test
    void testFromLittleEndianFromSupplier() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3));
    }

    @Test
    void testFromLittleEndianFromSupplierThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)), (int)9));
    }

    @Test
    void testFromLittleEndianFromSupplierThrowsForPrematureEnd() {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertThrows(IOException.class, () -> ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3));
    }

    @Test
    void testFromLittleEndianFromSupplierUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)4));
    }

    @Test
    void testToLittleEndianToByteArray() {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)262914L, (int)1, (int)3);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Arrays.copyOfRange(b, 1, 4));
    }

    @Test
    void testToLittleEndianToByteArrayUnsignedInt32() {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)2147746562L, (int)0, (int)4);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])b);
    }

    @Test
    void testToLittleEndianToConsumer() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)262914L, (int)3);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }

    @Test
    void testToLittleEndianToConsumerUnsignedInt32() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4, -128};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)2147746562L, (int)4);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }

    @Test
    void testToLittleEndianToDataOutput() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            DataOutputStream dos = new DataOutputStream(bos);
            ByteUtils.toLittleEndian((DataOutput)dos, (long)262914L, (int)3);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }

    @Test
    void testToLittleEndianToDataOutputUnsignedInt32() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4, -128};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            DataOutputStream dos = new DataOutputStream(bos);
            ByteUtils.toLittleEndian((DataOutput)dos, (long)2147746562L, (int)4);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }

    @Test
    void testToLittleEndianToStream() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteUtils.toLittleEndian((OutputStream)bos, (long)262914L, (int)3);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }

    @Test
    void testToLittleEndianToStreamUnsignedInt32() throws IOException {
        byte[] byteArray;
        byte[] expected = new byte[]{2, 3, 4, -128};
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteUtils.toLittleEndian((OutputStream)bos, (long)2147746562L, (int)4);
            byteArray = bos.toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteArray);
    }
}

