/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.tukaani.xz.LZMA2Options;

class LZMACompressorOutputStreamTest {
    @TempDir
    static Path tempDir;

    LZMACompressorOutputStreamTest() {
    }

    private void roundtrip(Path outPath, LZMA2Options options) throws IOException {
        String data = "Hello World!";
        try (LZMACompressorOutputStream out = ((LZMACompressorOutputStream.Builder)LZMACompressorOutputStream.builder().setPath(outPath)).setLzma2Options(options).get();){
            out.writeUtf8("Hello World!");
        }
        out = ((LZMACompressorInputStream.Builder)LZMACompressorInputStream.builder().setPath(outPath)).setMemoryLimitKiB(-1).get();
        try {
            Assertions.assertEquals((Object)"Hello World!", (Object)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Test
    void testBuilderOptionsAll() throws IOException {
        int dictSize = 4096;
        boolean lc = false;
        boolean lp = false;
        int pb = 4;
        int mode = 2;
        int niceLen = 8;
        int mf = 20;
        int depthLimit = 50;
        this.roundtrip(tempDir.resolve("out.lzma"), new LZMA2Options(4096, 0, 0, 4, 2, 8, 20, 50));
    }

    @Test
    void testBuilderOptionsDefault() throws IOException {
        this.roundtrip(tempDir.resolve("out.lzma"), new LZMA2Options());
    }

    @Test
    void testBuilderOptionsPreset() throws IOException {
        this.roundtrip(tempDir.resolve("out.lzma"), new LZMA2Options(9));
    }

    @Test
    void testBuilderPath() throws IOException {
        Path outPath = tempDir.resolve("out.lzma");
        try (LZMACompressorOutputStream out = ((LZMACompressorOutputStream.Builder)LZMACompressorOutputStream.builder().setPath(outPath)).get();){
            out.writeUtf8("Hello World!");
        }
    }
}

