/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BitStreamTest {
    BitStreamTest() {
    }

    @Test
    void testNextByte() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));){
            Assertions.assertEquals((int)0, (int)stream.readBit(), (String)"bit 0");
            Assertions.assertEquals((int)1, (int)stream.readBit(), (String)"bit 1");
            Assertions.assertEquals((int)0, (int)stream.readBit(), (String)"bit 2");
            Assertions.assertEquals((int)1, (int)stream.readBit(), (String)"bit 3");
            Assertions.assertEquals((int)94, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }

    @Test
    void testNextByteFromEmptyStream() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }

    @Test
    void testReadAlignedBytes() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));){
            Assertions.assertEquals((int)234, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)53, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }
}

