/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.time.Period;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.PeriodConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PeriodConverterTest {
    private Converter<Period> converter;

    protected Class<?> getExpectedType() {
        return Period.class;
    }

    protected Converter<Period> makeConverter() {
        return new PeriodConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"P2Y", "P5D", "P1Y2M3D"};
        Period[] expected = new Period[]{Period.parse("P2Y"), Period.parse("P5D"), Period.parse("P1Y2M3D")};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(Period.class, input[i]), (String)(message[i] + " to URI"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"http://www.apache.org"));
    }
}

