/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.awt.Color;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.ColorConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorConverterTest {
    private ColorConverter converter;

    @BeforeEach
    public void before() {
        this.converter = new ColorConverter();
    }

    @Test
    public void testColorBlank() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Color.class, (Object)"#"));
    }

    @Test
    public void testColorInvalidLength() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Color.class, (Object)"#F"));
    }

    @Test
    public void testConvertingColorName() {
        Color expected = Color.WHITE;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"white");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingColorNameCaps() {
        Color expected = Color.LIGHT_GRAY;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"LIGHTGRAY");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingJavaColorStringFull() {
        Color expected = Color.WHITE;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"java.awt.Color[r=255,g=255,b=255]");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingJavaColorStringWithoutBrackets() {
        Color expected = Color.DARK_GRAY;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"r=64,g=64,b=64");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingJavaColorStringWithoutColorPrefixes() {
        Color expected = Color.PINK;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"255,175,175");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingJavaColorStringWithoutPackage() {
        Color expected = Color.GREEN;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"[r=0,g=255,b=0]");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingJavaExtendsColorString() {
        Color expected = Color.MAGENTA;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"org.apache.ExtendedColor[r=255,g=0,b=255]");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingLiteralHex() {
        Color expected = Color.BLUE;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"0x0000FF");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingPattern() {
        Color expected = Color.BLACK;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"#000000");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingPattern3Digit() {
        Color expected = Color.WHITE;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"#FFF");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingPattern4Digit() {
        Color expected = Color.YELLOW;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"#FF0F");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingPatternWithAlpha() {
        Color expected = Color.LIGHT_GRAY;
        Color actual = (Color)this.converter.convert(Color.class, (Object)"#C0C0C0FF");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testInvalidNumber3() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Color.class, (Object)"#FFZ"));
    }

    @Test
    public void testInvalidNumber4() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Color.class, (Object)"#FFFY"));
    }
}

