/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils2.BeanUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Jira465Test {
    private static final String PATH = "foo[0]";
    private static final String NEW_VALUE = "2";
    private static final String OLD_VALUE = "1";

    private static void changeValue(Object bean) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.setProperty((Object)bean, (String)PATH, (Object)NEW_VALUE);
    }

    @Test
    public void testArrayIndexedProperty() throws Exception {
        ArrayIndexedProp bean = new ArrayIndexedProp();
        Jira465Test.changeValue(bean);
        Assertions.assertEquals((Object)NEW_VALUE, (Object)bean.getFoo(0), (String)"Wrong value");
    }

    @Test
    public void testArrayProperty() throws Exception {
        ArrayProp bean = new ArrayProp();
        Jira465Test.changeValue(bean);
        Assertions.assertEquals((Object)NEW_VALUE, (Object)bean.getFoo()[0], (String)"Wrong value");
    }

    @Test
    public void testListIndexedProperty() throws Exception {
        ListIndexedProp bean = new ListIndexedProp();
        Jira465Test.changeValue(bean);
        Assertions.assertEquals((Object)NEW_VALUE, (Object)bean.getFoo(0), (String)"Wrong value");
    }

    @Test
    public void testListProperty() throws Exception {
        ListProp bean = new ListProp();
        Jira465Test.changeValue(bean);
        Assertions.assertEquals((Object)NEW_VALUE, (Object)bean.getFoo().get(0), (String)"Wrong value");
    }

    public static class ArrayIndexedProp {
        private final Object[] foo = new Object[]{"1"};

        public Object getFoo(int i) {
            return this.foo[i];
        }

        public void setFoo(int i, Object value) {
            this.foo[i] = value;
        }
    }

    public static class ArrayProp {
        private Object[] foo = new Object[]{"1"};

        public Object[] getFoo() {
            return this.foo;
        }

        public void setFoo(Object[] foo) {
            this.foo = foo;
        }
    }

    public static class ListIndexedProp {
        private final List<String> foo = new ArrayList<String>(Arrays.asList("1"));

        public String getFoo(int i) {
            return this.foo.get(i);
        }

        public void setFoo(int i, String value) {
            this.foo.set(i, value);
        }
    }

    public static class ListProp {
        private List<String> foo = new ArrayList<String>(Arrays.asList("1"));

        public List<String> getFoo() {
            return this.foo;
        }

        public void setFoo(List<String> foo) {
            this.foo = foo;
        }
    }
}

