/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.ConvertUtilsBean;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.PassTestException;
import org.apache.commons.beanutils2.ThrowExceptionConverter;
import org.apache.commons.beanutils2.converters.DateConverter;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConvertUtilsTest {
    private void checkIntegerArray(Object value, int[] intArray) {
        Assertions.assertNotNull((Object)value, (String)"Returned value is not null");
        Assertions.assertEquals(intArray.getClass(), value.getClass(), (String)"Returned value is int[]");
        int[] results = (int[])value;
        Assertions.assertEquals((int)intArray.length, (int)results.length, (String)"Returned array length");
        for (int i = 0; i < intArray.length; ++i) {
            Assertions.assertEquals((int)intArray[i], (int)results[i], (String)("Returned array value " + i));
        }
    }

    private void checkStringArray(Object value, String[] stringArray) {
        Assertions.assertNotNull((Object)value, (String)"Returned value is not null");
        Assertions.assertEquals(stringArray.getClass(), value.getClass(), (String)"Returned value is String[]");
        String[] results = (String[])value;
        Assertions.assertEquals((int)stringArray.length, (int)results.length, (String)"Returned array length");
        for (int i = 0; i < stringArray.length; ++i) {
            Assertions.assertEquals((Object)stringArray[i], (Object)results[i], (String)("Returned array value " + i));
        }
    }

    @BeforeEach
    public void setUp() {
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        ConvertUtils.deregister();
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testConvertToString() throws Exception {
        Converter dummyConverter = (type, value) -> value;
        Converter fooConverter = (type, value) -> "Foo-Converter";
        DateConverter dateConverter = new DateConverter();
        dateConverter.setLocale(Locale.US);
        ConvertUtilsBean utils = new ConvertUtilsBean();
        utils.register((Converter)dateConverter, java.util.Date.class);
        utils.register(fooConverter, String.class);
        java.util.Date today = new java.util.Date();
        SimpleDateFormat fmt = new SimpleDateFormat("M/d/yy");
        String expected = fmt.format(today);
        Assertions.assertEquals((Object)expected, (Object)utils.convert((Object)today, String.class), (String)"DateConverter M/d/yy");
        utils.register(dummyConverter, java.util.Date.class);
        Assertions.assertEquals((Object)"Foo-Converter", (Object)utils.convert((Object)today, String.class), (String)"Date Converter doesn't do String conversion");
        utils.deregister(java.util.Date.class);
        Assertions.assertEquals((Object)"Foo-Converter", (Object)utils.convert((Object)today, String.class), (String)"No registered Date converter");
        utils.register(dummyConverter, String.class);
        Assertions.assertEquals((Object)today.toString(), (Object)utils.convert((Object)today, String.class), (String)"String Converter doesn't do Strings!!!");
        utils.deregister(String.class);
        Assertions.assertEquals((Object)today.toString(), (Object)utils.convert((Object)today, String.class), (String)"Object's toString()");
    }

    @Test
    public void testConvertUnsupportedTargetType() {
        ConvertUtilsBean utils = new ConvertUtilsBean();
        String value = "A test value";
        Assertions.assertSame((Object)value, (Object)utils.convert((Object)value, this.getClass()), (String)"Got different object");
    }

    @Test
    public void testDeregisteringSingleConverter() throws Exception {
        Object value = ConvertUtils.convert((String)"true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Standard conversion failed (1)");
        ConvertUtils.deregister(Boolean.TYPE);
        Assertions.assertNull((Object)ConvertUtils.lookup(Boolean.TYPE), (String)"Converter should be null");
    }

    @Test
    public void testNegativeIntegerArray() {
        int[] intArray = new int[]{};
        Object value = ConvertUtils.convert((String)null, intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"a", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ a }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"0,1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ 0, 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
    }

    @Test
    public void testNegativeScalar() {
        Object value = ConvertUtils.convert((String)"foo", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"foo", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"foo", Byte.TYPE);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)0);
        value = ConvertUtils.convert((String)"foo", Byte.class);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)0);
        Assertions.assertThrows(ConversionException.class, () -> ConvertUtils.convert((String)"org.apache.commons.beanutils2.Undefined", Class.class));
        value = ConvertUtils.convert((String)"foo", Double.TYPE);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)0.0, (double)0.005);
        value = ConvertUtils.convert((String)"foo", Double.class);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)0.0, (double)0.005);
        value = ConvertUtils.convert((String)"foo", Float.TYPE);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)0.0f, (float)0.005f);
        value = ConvertUtils.convert((String)"foo", Float.class);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)0.0f, (float)0.005f);
        value = ConvertUtils.convert((String)"foo", Integer.TYPE);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)0);
        value = ConvertUtils.convert((String)"foo", Integer.class);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)0);
        value = ConvertUtils.convert((String)"foo", Byte.TYPE);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)0);
        value = ConvertUtils.convert((String)"foo", Long.class);
        Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)((Long)value), (long)0L);
        value = ConvertUtils.convert((String)"foo", Short.TYPE);
        Assertions.assertInstanceOf(Short.class, (Object)value);
        Assertions.assertEquals((short)((Short)value), (short)0);
        value = ConvertUtils.convert((String)"foo", Short.class);
        Assertions.assertInstanceOf(Short.class, (Object)value);
        Assertions.assertEquals((short)((Short)value), (short)0);
    }

    @Test
    public void testNegativeStringArray() {
        String[] stringArray = new String[]{};
        Object value = ConvertUtils.convert((String)null, stringArray.getClass());
        this.checkStringArray(value, stringArray);
    }

    @Test
    public void testObjectToStringArray() {
        int[] intArray0 = new int[]{};
        int[] intArray1 = new int[]{123};
        int[] intArray2 = new int[]{123, 456};
        String[] stringArray0 = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "def"};
        Assertions.assertEquals(null, (Object)ConvertUtils.convert((Object)intArray0), (String)"intArray0");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)intArray1), (String)"intArray1");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)intArray2), (String)"intArray2");
        Assertions.assertEquals(null, (Object)ConvertUtils.convert((Object)stringArray0), (String)"stringArray0");
        Assertions.assertEquals((Object)"abc", (Object)ConvertUtils.convert((Object)stringArray1), (String)"stringArray1");
        Assertions.assertEquals((Object)"abc", (Object)ConvertUtils.convert((Object)stringArray2), (String)"stringArray2");
    }

    @Test
    public void testObjectToStringScalar() {
        Assertions.assertEquals((Object)"false", (Object)ConvertUtils.convert((Object)Boolean.FALSE), (String)"Boolean->String");
        Assertions.assertEquals((Object)"true", (Object)ConvertUtils.convert((Object)Boolean.TRUE), (String)"Boolean->String");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)123), (String)"Byte->String");
        Assertions.assertEquals((Object)"a", (Object)ConvertUtils.convert((Object)Character.valueOf('a')), (String)"Character->String");
        Assertions.assertEquals((Object)"123.0", (Object)ConvertUtils.convert((Object)123.0), (String)"Double->String");
        Assertions.assertEquals((Object)"123.0", (Object)ConvertUtils.convert((Object)Float.valueOf(123.0f)), (String)"Float->String");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)123), (String)"Integer->String");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)123L), (String)"Long->String");
        Assertions.assertEquals((Object)"123", (Object)ConvertUtils.convert((Object)123), (String)"Short->String");
        Assertions.assertEquals((Object)"abc", (Object)ConvertUtils.convert((Object)"abc"), (String)"String->String");
        Assertions.assertEquals(null, (Object)ConvertUtils.convert(null), (String)"String->String null");
    }

    @Test
    public void testPositiveArray() {
        String[] values1 = new String[]{"10", "20", "30"};
        int[] shape = ArrayUtils.EMPTY_INT_ARRAY;
        Object value = ConvertUtils.convert((String[])values1, shape.getClass());
        Assertions.assertEquals(shape.getClass(), value.getClass());
        int[] results1 = (int[])value;
        Assertions.assertEquals((int)10, (int)results1[0]);
        Assertions.assertEquals((int)20, (int)results1[1]);
        Assertions.assertEquals((int)30, (int)results1[2]);
        String[] values2 = new String[]{"100", "200", "300"};
        value = ConvertUtils.convert((String[])values2, shape.getClass());
        Assertions.assertEquals(shape.getClass(), value.getClass());
        int[] results2 = (int[])value;
        Assertions.assertEquals((int)100, (int)results2[0]);
        Assertions.assertEquals((int)200, (int)results2[1]);
        Assertions.assertEquals((int)300, (int)results2[2]);
        value = ConvertUtils.convert((String[])values1, Integer.TYPE);
        Assertions.assertEquals(Integer.class, value.getClass());
        Assertions.assertEquals((Object)10, (Object)value);
    }

    @Test
    public void testPositiveIntegerArray() {
        int[] intArray = new int[]{};
        int[] intArray1 = new int[]{0};
        int[] intArray2 = new int[]{0, 10};
        Class<?> intArrayClass = intArray.getClass();
        Object value = ConvertUtils.convert((String)"{  }", intArrayClass);
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"0", intArrayClass);
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)" 0 ", intArrayClass);
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)"{ 0 }", intArrayClass);
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)"0,10", intArrayClass);
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"0 10", intArrayClass);
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{0,10}", intArrayClass);
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{0 10}", intArrayClass);
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{ 0, 10 }", intArrayClass);
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{ 0 10 }", intArrayClass);
        this.checkIntegerArray(value, intArray2);
    }

    @Test
    public void testPositiveScalar() {
        Object value = ConvertUtils.convert((String)"true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"true", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"yes", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"yes", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"y", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"y", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"on", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"on", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true);
        value = ConvertUtils.convert((String)"false", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"false", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"no", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"no", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"n", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"n", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"off", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"off", Boolean.class);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)false);
        value = ConvertUtils.convert((String)"123", Byte.TYPE);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)123);
        value = ConvertUtils.convert((String)"123", Byte.class);
        Assertions.assertInstanceOf(Byte.class, (Object)value);
        Assertions.assertEquals((byte)((Byte)value), (byte)123);
        value = ConvertUtils.convert((String)"a", Character.TYPE);
        Assertions.assertInstanceOf(Character.class, (Object)value);
        Assertions.assertEquals((char)((Character)value).charValue(), (char)'a');
        value = ConvertUtils.convert((String)"a", Character.class);
        Assertions.assertInstanceOf(Character.class, (Object)value);
        Assertions.assertEquals((char)((Character)value).charValue(), (char)'a');
        value = ConvertUtils.convert((String)"java.lang.String", Class.class);
        Assertions.assertInstanceOf(Class.class, (Object)value);
        Assertions.assertEquals(String.class, (Object)value);
        value = ConvertUtils.convert((String)"123.456", Double.TYPE);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = ConvertUtils.convert((String)"123.456", Double.class);
        Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = ConvertUtils.convert((String)"123.456", Float.TYPE);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = ConvertUtils.convert((String)"123.456", Float.class);
        Assertions.assertInstanceOf(Float.class, (Object)value);
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = ConvertUtils.convert((String)"123", Integer.TYPE);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)123);
        value = ConvertUtils.convert((String)"123", Integer.class);
        Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)((Integer)value), (int)123);
        value = ConvertUtils.convert((String)"123", Long.TYPE);
        Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)((Long)value), (long)123L);
        value = ConvertUtils.convert((String)"123", Long.class);
        Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)((Long)value), (long)123L);
        value = ConvertUtils.convert((String)"123", Short.TYPE);
        Assertions.assertInstanceOf(Short.class, (Object)value);
        Assertions.assertEquals((short)((Short)value), (short)123);
        value = ConvertUtils.convert((String)"123", Short.class);
        Assertions.assertInstanceOf(Short.class, (Object)value);
        Assertions.assertEquals((short)((Short)value), (short)123);
        String input = "2002-03-17";
        value = ConvertUtils.convert((String)input, Date.class);
        Assertions.assertInstanceOf(Date.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
        input = "20:30:40";
        value = ConvertUtils.convert((String)input, Time.class);
        Assertions.assertInstanceOf(Time.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
        input = "2002-03-17 20:30:40.0";
        value = ConvertUtils.convert((String)input, Timestamp.class);
        Assertions.assertInstanceOf(Timestamp.class, (Object)value);
        Assertions.assertEquals((Object)input, (Object)value.toString());
    }

    @Test
    public void testPositiveStringArray() {
        String[] stringArray = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "de,f"};
        Object value = ConvertUtils.convert((String)"", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)" ", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"{}", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"{  }", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"abc", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{abc}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"\"abc\"", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{\"abc\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"'abc'", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{'abc'}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"abc 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{abc, 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"\"abc\",\"de,f\"", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{\"abc\" 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"'abc' 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{'abc', \"de,f\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
    }

    @Test
    public void testSeparateConvertInstances() throws Exception {
        ConvertUtilsBean utilsOne = new ConvertUtilsBean();
        ConvertUtilsBean utilsTwo = new ConvertUtilsBean();
        Object value = utilsOne.convert("true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Standard conversion failed (1)");
        value = utilsTwo.convert("true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Standard conversion failed (2)");
        utilsOne.register((Converter)new ThrowExceptionConverter(), Boolean.TYPE);
        Assertions.assertThrows(PassTestException.class, () -> utilsOne.convert("true", Boolean.TYPE));
        value = utilsTwo.convert("true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Standard conversion failed (3)");
        utilsOne.deregister();
        value = utilsOne.convert("true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Instance deregister failed.");
        value = utilsTwo.convert("true", Boolean.TYPE);
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)((Boolean)value), (Object)true, (String)"Standard conversion failed (4)");
    }
}

