/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.FluentSelectPrefetchRouterAction;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.Select;

public abstract class FluentSelect<T>
extends AbstractQuery
implements Select<T> {
    protected Class<?> entityType;
    protected String entityName;
    protected String dbEntityName;
    protected Expression where;
    protected Expression having;
    boolean havingExpressionIsActive = false;
    protected Collection<Ordering> orderings;
    boolean distinct;

    protected FluentSelect() {
    }

    protected Object resolveRoot(EntityResolver resolver) {
        Serializable root;
        if (this.entityType != null) {
            root = this.entityType;
        } else if (this.entityName != null) {
            ObjEntity entity = resolver.getObjEntity(this.entityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized ObjEntity name: %s", this.entityName);
            }
            root = entity;
        } else if (this.dbEntityName != null) {
            DbEntity entity = resolver.getDbEntity(this.dbEntityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized DbEntity name: %s", this.dbEntityName);
            }
            root = entity;
        } else {
            throw new CayenneRuntimeException("Undefined root entity of the query", new Object[0]);
        }
        return root;
    }

    public int getStatementFetchSize() {
        return this.getBaseMetaData().getStatementFetchSize();
    }

    public int getQueryTimeout() {
        return this.getBaseMetaData().getQueryTimeout();
    }

    public int getPageSize() {
        return this.getBaseMetaData().getPageSize();
    }

    public int getLimit() {
        return this.getBaseMetaData().getFetchLimit();
    }

    public int getOffset() {
        return this.getBaseMetaData().getFetchOffset();
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public Expression getWhere() {
        return this.where;
    }

    public Expression getHaving() {
        return this.having;
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.getBaseMetaData().getPrefetchTree();
    }

    void setActiveExpression(Expression exp) {
        if (this.havingExpressionIsActive) {
            this.having = exp;
        } else {
            this.where = exp;
        }
    }

    Expression getActiveExpression() {
        if (this.havingExpressionIsActive) {
            return this.having;
        }
        return this.where;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.objectSelectAction(this);
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        super.route(router, resolver, substitutedQuery);
        if (this.getPageSize() <= 0) {
            this.routePrefetches(router, resolver);
        }
    }

    public boolean isFetchingDataRows() {
        return false;
    }

    protected void routePrefetches(QueryRouter router, EntityResolver resolver) {
        new FluentSelectPrefetchRouterAction().route(this, router, resolver);
    }

    public Collection<Property<?>> getColumns() {
        return null;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void initWithProperties(Map<String, String> properties) {
        this.getBaseMetaData().initWithProperties(properties);
    }
}

