/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.state.DisplayEventType;

class EntityDisplayEventType
extends DisplayEventType {
    EntityDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataNodeDescriptor dataNode = dataChannel.getNodeDescriptor(this.preferences.getNode());
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Entity entity = this.getLastEntity(dataMap);
        if (entity == null) {
            return;
        }
        EntityDisplayEvent entityDisplayEvent = new EntityDisplayEvent(this, entity, dataMap, dataNode, dataChannel);
        if (entity instanceof ObjEntity) {
            this.controller.fireObjEntityDisplayEvent(entityDisplayEvent);
        } else if (entity instanceof DbEntity) {
            this.controller.fireDbEntityDisplayEvent(entityDisplayEvent);
        }
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(EntityDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setNode(this.controller.getCurrentDataNode() != null ? this.controller.getCurrentDataNode().getName() : "");
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        if (this.controller.getCurrentObjEntity() != null) {
            this.preferences.setObjEntity(this.controller.getCurrentObjEntity().getName());
            this.preferences.setDbEntity(null);
        } else if (this.controller.getCurrentDbEntity() != null) {
            this.preferences.setDbEntity(this.controller.getCurrentDbEntity().getName());
            this.preferences.setObjEntity(null);
        }
    }

    Entity getLastEntity(DataMap dataMap) {
        return !this.preferences.getObjEntity().isEmpty() ? dataMap.getObjEntity(this.preferences.getObjEntity()) : dataMap.getDbEntity(this.preferences.getDbEntity());
    }
}

