/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import javax.swing.JOptionPane;

public class UnsavedChangesDialog {
    private static final String SAVE_AND_CLOSE = "Save Changes";
    private static final String CLOSE_WITHOUT_SAVE = "Discard Changes";
    private static final String CANCEL = "Cancel";
    protected Component parent;
    protected String result = "Cancel";

    public UnsavedChangesDialog(Component parent) {
        this.parent = parent;
    }

    public void show() {
        JOptionPane pane = new JOptionPane("You have unsaved changes. Do you want to save them?", 3);
        pane.setOptions(new Object[]{SAVE_AND_CLOSE, CLOSE_WITHOUT_SAVE, CANCEL});
        pane.setInitialValue(SAVE_AND_CLOSE);
        pane.createDialog(this.parent, "Unsaved Changes").setVisible(true);
        Object selectedValue = pane.getValue();
        this.result = CANCEL;
        if (SAVE_AND_CLOSE.equals(selectedValue)) {
            this.result = SAVE_AND_CLOSE;
        } else if (CLOSE_WITHOUT_SAVE.equals(selectedValue)) {
            this.result = CLOSE_WITHOUT_SAVE;
        }
    }

    public boolean shouldSave() {
        return SAVE_AND_CLOSE.equals(this.result);
    }

    public boolean shouldNotSave() {
        return CLOSE_WITHOUT_SAVE.equals(this.result);
    }

    public boolean shouldCancel() {
        return this.result == null || CANCEL.equals(this.result);
    }
}

