/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Process documents using Docling library for parsing and conversion.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DoclingEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Docling component.
     */
    public interface DoclingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDoclingEndpointBuilder advanced() {
            return (AdvancedDoclingEndpointBuilder) this;
        }

        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder contentInBody(boolean contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder contentInBody(String contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
        /**
         * Docling-serve API URL (e.g., http://localhost:5001).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: http://localhost:5001
         * Group: producer
         * 
         * @param doclingServeUrl the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder doclingServeUrl(String doclingServeUrl) {
            doSetProperty("doclingServeUrl", doclingServeUrl);
            return this;
        }
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder enableOCR(boolean enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder enableOCR(String enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
        /**
         * Show layout information with bounding boxes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeLayoutInfo(boolean includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
        /**
         * Show layout information with bounding boxes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeLayoutInfo(String includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
        /**
         * Language code for OCR processing.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: en
         * Group: producer
         * 
         * @param ocrLanguage the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder ocrLanguage(String ocrLanguage) {
            doSetProperty("ocrLanguage", ocrLanguage);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.docling.DoclingOperations</code>
         * type.
         * 
         * Required: true
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder operation(org.apache.camel.component.docling.DoclingOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.docling.DoclingOperations</code>
         * type.
         * 
         * Required: true
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Output format for document conversion.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: markdown
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder outputFormat(String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
        /**
         * Use docling-serve API instead of CLI command.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDoclingServe the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder useDoclingServe(boolean useDoclingServe) {
            doSetProperty("useDoclingServe", useDoclingServe);
            return this;
        }
        /**
         * Use docling-serve API instead of CLI command.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDoclingServe the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder useDoclingServe(String useDoclingServe) {
            doSetProperty("useDoclingServe", useDoclingServe);
            return this;
        }
        /**
         * Fail entire batch on first error (true) or continue processing
         * remaining documents (false).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: batch
         * 
         * @param batchFailOnFirstError the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchFailOnFirstError(boolean batchFailOnFirstError) {
            doSetProperty("batchFailOnFirstError", batchFailOnFirstError);
            return this;
        }
        /**
         * Fail entire batch on first error (true) or continue processing
         * remaining documents (false).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: batch
         * 
         * @param batchFailOnFirstError the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchFailOnFirstError(String batchFailOnFirstError) {
            doSetProperty("batchFailOnFirstError", batchFailOnFirstError);
            return this;
        }
        /**
         * Number of parallel threads for batch processing.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4
         * Group: batch
         * 
         * @param batchParallelism the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchParallelism(int batchParallelism) {
            doSetProperty("batchParallelism", batchParallelism);
            return this;
        }
        /**
         * Number of parallel threads for batch processing.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4
         * Group: batch
         * 
         * @param batchParallelism the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchParallelism(String batchParallelism) {
            doSetProperty("batchParallelism", batchParallelism);
            return this;
        }
        /**
         * Maximum number of documents to process in a single batch (batch
         * operations only).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: batch
         * 
         * @param batchSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchSize(int batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
        /**
         * Maximum number of documents to process in a single batch (batch
         * operations only).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: batch
         * 
         * @param batchSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchSize(String batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
        /**
         * Maximum time to wait for batch completion in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 300000
         * Group: batch
         * 
         * @param batchTimeout the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchTimeout(long batchTimeout) {
            doSetProperty("batchTimeout", batchTimeout);
            return this;
        }
        /**
         * Maximum time to wait for batch completion in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 300000
         * Group: batch
         * 
         * @param batchTimeout the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder batchTimeout(String batchTimeout) {
            doSetProperty("batchTimeout", batchTimeout);
            return this;
        }
        /**
         * Split batch results into individual exchanges (one per document)
         * instead of single BatchProcessingResults.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: batch
         * 
         * @param splitBatchResults the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder splitBatchResults(boolean splitBatchResults) {
            doSetProperty("splitBatchResults", splitBatchResults);
            return this;
        }
        /**
         * Split batch results into individual exchanges (one per document)
         * instead of single BatchProcessingResults.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: batch
         * 
         * @param splitBatchResults the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder splitBatchResults(String splitBatchResults) {
            doSetProperty("splitBatchResults", splitBatchResults);
            return this;
        }
        /**
         * Include metadata in message headers when extracting metadata.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: metadata
         * 
         * @param includeMetadataInHeaders the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeMetadataInHeaders(boolean includeMetadataInHeaders) {
            doSetProperty("includeMetadataInHeaders", includeMetadataInHeaders);
            return this;
        }
        /**
         * Include metadata in message headers when extracting metadata.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: metadata
         * 
         * @param includeMetadataInHeaders the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeMetadataInHeaders(String includeMetadataInHeaders) {
            doSetProperty("includeMetadataInHeaders", includeMetadataInHeaders);
            return this;
        }
        /**
         * Include raw metadata as returned by the parser.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: metadata
         * 
         * @param includeRawMetadata the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeRawMetadata(boolean includeRawMetadata) {
            doSetProperty("includeRawMetadata", includeRawMetadata);
            return this;
        }
        /**
         * Include raw metadata as returned by the parser.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: metadata
         * 
         * @param includeRawMetadata the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeRawMetadata(String includeRawMetadata) {
            doSetProperty("includeRawMetadata", includeRawMetadata);
            return this;
        }
        /**
         * Header name for API key authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: X-API-Key
         * Group: security
         * 
         * @param apiKeyHeader the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder apiKeyHeader(String apiKeyHeader) {
            doSetProperty("apiKeyHeader", apiKeyHeader);
            return this;
        }
        /**
         * Authentication scheme (BEARER, API_KEY, NONE).
         * 
         * The option is a:
         * <code>org.apache.camel.component.docling.AuthenticationScheme</code>
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationScheme the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder authenticationScheme(org.apache.camel.component.docling.AuthenticationScheme authenticationScheme) {
            doSetProperty("authenticationScheme", authenticationScheme);
            return this;
        }
        /**
         * Authentication scheme (BEARER, API_KEY, NONE).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.docling.AuthenticationScheme</code>
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationScheme the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder authenticationScheme(String authenticationScheme) {
            doSetProperty("authenticationScheme", authenticationScheme);
            return this;
        }
        /**
         * Authentication token for docling-serve API (Bearer token or API key).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authenticationToken the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder authenticationToken(String authenticationToken) {
            doSetProperty("authenticationToken", authenticationToken);
            return this;
        }
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder maxFileSize(long maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder maxFileSize(String maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Docling component.
     */
    public interface AdvancedDoclingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default DoclingEndpointBuilder basic() {
            return (DoclingEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Abort processing on error.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param abortOnError the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder abortOnError(Boolean abortOnError) {
            doSetProperty("abortOnError", abortOnError);
            return this;
        }
        /**
         * Abort processing on error.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param abortOnError the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder abortOnError(String abortOnError) {
            doSetProperty("abortOnError", abortOnError);
            return this;
        }
        /**
         * Polling interval for async conversion status in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2000
         * Group: advanced
         * 
         * @param asyncPollInterval the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder asyncPollInterval(long asyncPollInterval) {
            doSetProperty("asyncPollInterval", asyncPollInterval);
            return this;
        }
        /**
         * Polling interval for async conversion status in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2000
         * Group: advanced
         * 
         * @param asyncPollInterval the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder asyncPollInterval(String asyncPollInterval) {
            doSetProperty("asyncPollInterval", asyncPollInterval);
            return this;
        }
        /**
         * Maximum time to wait for async conversion completion in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param asyncTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder asyncTimeout(long asyncTimeout) {
            doSetProperty("asyncTimeout", asyncTimeout);
            return this;
        }
        /**
         * Maximum time to wait for async conversion completion in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param asyncTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder asyncTimeout(String asyncTimeout) {
            doSetProperty("asyncTimeout", asyncTimeout);
            return this;
        }
        /**
         * Path to Docling Python executable or command.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param doclingCommand the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doclingCommand(String doclingCommand) {
            doSetProperty("doclingCommand", doclingCommand);
            return this;
        }
        /**
         * Enable code enrichment in document processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doCodeEnrichment the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doCodeEnrichment(Boolean doCodeEnrichment) {
            doSetProperty("doCodeEnrichment", doCodeEnrichment);
            return this;
        }
        /**
         * Enable code enrichment in document processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doCodeEnrichment the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doCodeEnrichment(String doCodeEnrichment) {
            doSetProperty("doCodeEnrichment", doCodeEnrichment);
            return this;
        }
        /**
         * Document processing timeout in seconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: advanced
         * 
         * @param documentTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder documentTimeout(Long documentTimeout) {
            doSetProperty("documentTimeout", documentTimeout);
            return this;
        }
        /**
         * Document processing timeout in seconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: advanced
         * 
         * @param documentTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder documentTimeout(String documentTimeout) {
            doSetProperty("documentTimeout", documentTimeout);
            return this;
        }
        /**
         * Enable formula enrichment in document processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doFormulaEnrichment the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doFormulaEnrichment(Boolean doFormulaEnrichment) {
            doSetProperty("doFormulaEnrichment", doFormulaEnrichment);
            return this;
        }
        /**
         * Enable formula enrichment in document processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doFormulaEnrichment the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doFormulaEnrichment(String doFormulaEnrichment) {
            doSetProperty("doFormulaEnrichment", doFormulaEnrichment);
            return this;
        }
        /**
         * Enable OCR processing in docling-serve API mode. When not set, the
         * server uses its own defaults. Set enableOCR to false to explicitly
         * disable OCR.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doOcr the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doOcr(Boolean doOcr) {
            doSetProperty("doOcr", doOcr);
            return this;
        }
        /**
         * Enable OCR processing in docling-serve API mode. When not set, the
         * server uses its own defaults. Set enableOCR to false to explicitly
         * disable OCR.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doOcr the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doOcr(String doOcr) {
            doSetProperty("doOcr", doOcr);
            return this;
        }
        /**
         * Enable picture classification in document processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doPictureClassification the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doPictureClassification(Boolean doPictureClassification) {
            doSetProperty("doPictureClassification", doPictureClassification);
            return this;
        }
        /**
         * Enable picture classification in document processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doPictureClassification the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doPictureClassification(String doPictureClassification) {
            doSetProperty("doPictureClassification", doPictureClassification);
            return this;
        }
        /**
         * Enable picture description generation in document processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doPictureDescription the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doPictureDescription(Boolean doPictureDescription) {
            doSetProperty("doPictureDescription", doPictureDescription);
            return this;
        }
        /**
         * Enable picture description generation in document processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doPictureDescription the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doPictureDescription(String doPictureDescription) {
            doSetProperty("doPictureDescription", doPictureDescription);
            return this;
        }
        /**
         * Enable table structure recognition.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doTableStructure the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doTableStructure(Boolean doTableStructure) {
            doSetProperty("doTableStructure", doTableStructure);
            return this;
        }
        /**
         * Enable table structure recognition.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param doTableStructure the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doTableStructure(String doTableStructure) {
            doSetProperty("doTableStructure", doTableStructure);
            return this;
        }
        /**
         * Force OCR processing even for digital documents.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceOcr the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder forceOcr(Boolean forceOcr) {
            doSetProperty("forceOcr", forceOcr);
            return this;
        }
        /**
         * Force OCR processing even for digital documents.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceOcr the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder forceOcr(String forceOcr) {
            doSetProperty("forceOcr", forceOcr);
            return this;
        }
        /**
         * Image export mode for referenced images.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param imageExportMode the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder imageExportMode(String imageExportMode) {
            doSetProperty("imageExportMode", imageExportMode);
            return this;
        }
        /**
         * Scale factor for exported images.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param imagesScale the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder imagesScale(Double imagesScale) {
            doSetProperty("imagesScale", imagesScale);
            return this;
        }
        /**
         * Scale factor for exported images.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param imagesScale the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder imagesScale(String imagesScale) {
            doSetProperty("imagesScale", imagesScale);
            return this;
        }
        /**
         * Include images in the conversion output.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeImages the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder includeImages(Boolean includeImages) {
            doSetProperty("includeImages", includeImages);
            return this;
        }
        /**
         * Include images in the conversion output.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeImages the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder includeImages(String includeImages) {
            doSetProperty("includeImages", includeImages);
            return this;
        }
        /**
         * Placeholder string for page breaks in markdown output.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param mdPageBreakPlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder mdPageBreakPlaceholder(String mdPageBreakPlaceholder) {
            doSetProperty("mdPageBreakPlaceholder", mdPageBreakPlaceholder);
            return this;
        }
        /**
         * OCR engine to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param ocrEngine the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder ocrEngine(String ocrEngine) {
            doSetProperty("ocrEngine", ocrEngine);
            return this;
        }
        /**
         * PDF parsing backend.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param pdfBackend the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder pdfBackend(String pdfBackend) {
            doSetProperty("pdfBackend", pdfBackend);
            return this;
        }
        /**
         * Processing pipeline to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param pipeline the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder pipeline(String pipeline) {
            doSetProperty("pipeline", pipeline);
            return this;
        }
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder processTimeout(long processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder processTimeout(String processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
        /**
         * Enable table cell matching post-processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tableCellMatching the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder tableCellMatching(Boolean tableCellMatching) {
            doSetProperty("tableCellMatching", tableCellMatching);
            return this;
        }
        /**
         * Enable table cell matching post-processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tableCellMatching the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder tableCellMatching(String tableCellMatching) {
            doSetProperty("tableCellMatching", tableCellMatching);
            return this;
        }
        /**
         * Table structure recognition mode.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param tableMode the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder tableMode(String tableMode) {
            doSetProperty("tableMode", tableMode);
            return this;
        }
        /**
         * Use asynchronous conversion mode (docling-serve API only).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useAsyncMode the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder useAsyncMode(boolean useAsyncMode) {
            doSetProperty("useAsyncMode", useAsyncMode);
            return this;
        }
        /**
         * Use asynchronous conversion mode (docling-serve API only).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useAsyncMode the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder useAsyncMode(String useAsyncMode) {
            doSetProperty("useAsyncMode", useAsyncMode);
            return this;
        }
        /**
         * Working directory for Docling execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param workingDirectory the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder workingDirectory(String workingDirectory) {
            doSetProperty("workingDirectory", workingDirectory);
            return this;
        }
    }

    public interface DoclingBuilders {
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * @return the dsl builder for the headers' name.
         */
        default DoclingHeaderNameBuilder docling() {
            return DoclingHeaderNameBuilder.INSTANCE;
        }
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * Syntax: <code>docling:operationId</code>
         * 
         * Path parameter: operationId (required)
         * The operation identifier
         * 
         * @param path operationId
         * @return the dsl builder
         */
        default DoclingEndpointBuilder docling(String path) {
            return DoclingEndpointBuilderFactory.endpointBuilder("docling", path);
        }
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * Syntax: <code>docling:operationId</code>
         * 
         * Path parameter: operationId (required)
         * The operation identifier
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operationId
         * @return the dsl builder
         */
        default DoclingEndpointBuilder docling(String componentName, String path) {
            return DoclingEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Docling component.
     */
    public static class DoclingHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DoclingHeaderNameBuilder INSTANCE = new DoclingHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code DoclingOperations} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOperation}.
         */
        public String doclingOperation() {
            return "CamelDoclingOperation";
        }
        /**
         * The output format for conversion.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOutputFormat}.
         */
        public String doclingOutputFormat() {
            return "CamelDoclingOutputFormat";
        }
        /**
         * The input file path or content.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingInputFilePath}.
         */
        public String doclingInputFilePath() {
            return "CamelDoclingInputFilePath";
        }
        /**
         * The output file path for saving result.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOutputFilePath}.
         */
        public String doclingOutputFilePath() {
            return "CamelDoclingOutputFilePath";
        }
        /**
         * Additional processing options.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingProcessingOptions}.
         */
        public String doclingProcessingOptions() {
            return "CamelDoclingProcessingOptions";
        }
        /**
         * Whether to include OCR processing.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingEnableOCR}.
         */
        public String doclingEnableOCR() {
            return "CamelDoclingEnableOCR";
        }
        /**
         * Language for OCR processing.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOCRLanguage}.
         */
        public String doclingOCRLanguage() {
            return "CamelDoclingOCRLanguage";
        }
        /**
         * Custom command line arguments to pass to Docling.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingCustomArguments}.
         */
        public String doclingCustomArguments() {
            return "CamelDoclingCustomArguments";
        }
        /**
         * Use asynchronous conversion mode (overrides endpoint configuration).
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingUseAsyncMode}.
         */
        public String doclingUseAsyncMode() {
            return "CamelDoclingUseAsyncMode";
        }
        /**
         * Polling interval for async conversion status in milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingAsyncPollInterval}.
         */
        public String doclingAsyncPollInterval() {
            return "CamelDoclingAsyncPollInterval";
        }
        /**
         * Maximum time to wait for async conversion completion in milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingAsyncTimeout}.
         */
        public String doclingAsyncTimeout() {
            return "CamelDoclingAsyncTimeout";
        }
        /**
         * Task ID for checking async conversion status.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingTaskId}.
         */
        public String doclingTaskId() {
            return "CamelDoclingTaskId";
        }
        /**
         * Override batch size for this operation.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchSize}.
         */
        public String doclingBatchSize() {
            return "CamelDoclingBatchSize";
        }
        /**
         * Override batch parallelism for this operation.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchParallelism}.
         */
        public String doclingBatchParallelism() {
            return "CamelDoclingBatchParallelism";
        }
        /**
         * Override batch fail on first error setting for this operation.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchFailOnFirstError}.
         */
        public String doclingBatchFailOnFirstError() {
            return "CamelDoclingBatchFailOnFirstError";
        }
        /**
         * Override batch timeout for this operation in milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchTimeout}.
         */
        public String doclingBatchTimeout() {
            return "CamelDoclingBatchTimeout";
        }
        /**
         * Total number of documents in the batch.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchTotalDocuments}.
         */
        public String doclingBatchTotalDocuments() {
            return "CamelDoclingBatchTotalDocuments";
        }
        /**
         * Number of successfully processed documents in the batch.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchSuccessCount}.
         */
        public String doclingBatchSuccessCount() {
            return "CamelDoclingBatchSuccessCount";
        }
        /**
         * Number of failed documents in the batch.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchFailureCount}.
         */
        public String doclingBatchFailureCount() {
            return "CamelDoclingBatchFailureCount";
        }
        /**
         * Total processing time for the batch in milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchProcessingTime}.
         */
        public String doclingBatchProcessingTime() {
            return "CamelDoclingBatchProcessingTime";
        }
        /**
         * Split batch results into individual exchanges instead of single
         * BatchProcessingResults.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingBatchSplitResults}.
         */
        public String doclingBatchSplitResults() {
            return "CamelDoclingBatchSplitResults";
        }
        /**
         * Number of pages in the document.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataPageCount}.
         */
        public String doclingMetadataPageCount() {
            return "CamelDoclingMetadataPageCount";
        }
        /**
         * Document language code.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataLanguage}.
         */
        public String doclingMetadataLanguage() {
            return "CamelDoclingMetadataLanguage";
        }
        /**
         * Document type/format.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataDocumentType}.
         */
        public String doclingMetadataDocumentType() {
            return "CamelDoclingMetadataDocumentType";
        }
        /**
         * Document format (MIME type).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataFormat}.
         */
        public String doclingMetadataFormat() {
            return "CamelDoclingMetadataFormat";
        }
        /**
         * File size in bytes.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataFileSize}.
         */
        public String doclingMetadataFileSize() {
            return "CamelDoclingMetadataFileSize";
        }
        /**
         * File name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataFileName}.
         */
        public String doclingMetadataFileName() {
            return "CamelDoclingMetadataFileName";
        }
        /**
         * Raw metadata fields as a Map.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingMetadataRaw}.
         */
        public String doclingMetadataRaw() {
            return "CamelDoclingMetadataRaw";
        }
    }
    static DoclingEndpointBuilder endpointBuilder(String componentName, String path) {
        class DoclingEndpointBuilderImpl extends AbstractEndpointBuilder implements DoclingEndpointBuilder, AdvancedDoclingEndpointBuilder {
            public DoclingEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DoclingEndpointBuilderImpl(path);
    }
}