/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.cyberark.vault.CyberArkVaultComponent;

/**
 * Retrieve secrets from CyberArk Conjur Vault.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface CyberarkVaultComponentBuilderFactory {

    /**
     * CyberArk Vault (camel-cyberark-vault)
     * Retrieve secrets from CyberArk Conjur Vault.
     * 
     * Category: cloud,security
     * Since: 4.17
     * Maven coordinates: org.apache.camel:camel-cyberark-vault
     * 
     * @return the dsl builder
     */
    static CyberarkVaultComponentBuilder cyberarkVault() {
        return new CyberarkVaultComponentBuilderImpl();
    }

    /**
     * Builder for the CyberArk Vault component.
     */
    interface CyberarkVaultComponentBuilder extends ComponentBuilder<CyberArkVaultComponent> {
    
        /**
         * The CyberArk Conjur account name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param account the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder account(java.lang.String account) {
            doSetProperty("account", account);
            return this;
        }
    
        /**
         * Path to the SSL certificate for verification.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param certificatePath the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder certificatePath(java.lang.String certificatePath) {
            doSetProperty("certificatePath", certificatePath);
            return this;
        }
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder configuration(org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Reference to a ConjurClient instance in the registry.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.cyberark.vault.client.ConjurClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param conjurClient the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder conjurClient(org.apache.camel.component.cyberark.vault.client.ConjurClient conjurClient) {
            doSetProperty("conjurClient", conjurClient);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * The operation to perform. It can be getSecret or createSecret.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.cyberark.vault.CyberArkVaultOperations&lt;/code&gt; type.
         * 
         * Default: getSecret
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder operation(org.apache.camel.component.cyberark.vault.CyberArkVaultOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        /**
         * The secret ID to retrieve from CyberArk Conjur.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param secretId the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder secretId(java.lang.String secretId) {
            doSetProperty("secretId", secretId);
            return this;
        }
    
        /**
         * The CyberArk Conjur instance URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder url(java.lang.String url) {
            doSetProperty("url", url);
            return this;
        }
    
        
        /**
         * Whether to verify SSL certificates when connecting to CyberArk
         * Conjur.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder verifySsl(boolean verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * The API key for authentication with CyberArk Conjur.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    
        /**
         * Pre-authenticated token to use for CyberArk Conjur.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authToken the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder authToken(java.lang.String authToken) {
            doSetProperty("authToken", authToken);
            return this;
        }
    
        /**
         * The password for authentication with CyberArk Conjur.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        /**
         * The username for authentication with CyberArk Conjur.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CyberarkVaultComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    class CyberarkVaultComponentBuilderImpl
            extends AbstractComponentBuilder<CyberArkVaultComponent>
            implements CyberarkVaultComponentBuilder {
        @Override
        protected CyberArkVaultComponent buildConcreteComponent() {
            return new CyberArkVaultComponent();
        }
        private org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration getOrCreateConfiguration(CyberArkVaultComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "account": getOrCreateConfiguration((CyberArkVaultComponent) component).setAccount((java.lang.String) value); return true;
            case "certificatePath": getOrCreateConfiguration((CyberArkVaultComponent) component).setCertificatePath((java.lang.String) value); return true;
            case "configuration": ((CyberArkVaultComponent) component).setConfiguration((org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration) value); return true;
            case "conjurClient": getOrCreateConfiguration((CyberArkVaultComponent) component).setConjurClient((org.apache.camel.component.cyberark.vault.client.ConjurClient) value); return true;
            case "lazyStartProducer": ((CyberArkVaultComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((CyberArkVaultComponent) component).setOperation((org.apache.camel.component.cyberark.vault.CyberArkVaultOperations) value); return true;
            case "secretId": getOrCreateConfiguration((CyberArkVaultComponent) component).setSecretId((java.lang.String) value); return true;
            case "url": getOrCreateConfiguration((CyberArkVaultComponent) component).setUrl((java.lang.String) value); return true;
            case "verifySsl": getOrCreateConfiguration((CyberArkVaultComponent) component).setVerifySsl((boolean) value); return true;
            case "autowiredEnabled": ((CyberArkVaultComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((CyberArkVaultComponent) component).setApiKey((java.lang.String) value); return true;
            case "authToken": getOrCreateConfiguration((CyberArkVaultComponent) component).setAuthToken((java.lang.String) value); return true;
            case "password": getOrCreateConfiguration((CyberArkVaultComponent) component).setPassword((java.lang.String) value); return true;
            case "username": getOrCreateConfiguration((CyberArkVaultComponent) component).setUsername((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}