/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class CamelCaseInsentiveHeadersTrueTest extends ContextTestSupport {

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setCaseInsensitiveHeaders(true);
        return context;
    }

    @Test
    public void testCasesensitive() throws Exception {
        getMockEndpoint("mock:foo").expectedBodiesReceived("Hello foo", "Hello bar");
        getMockEndpoint("mock:bar").expectedMessageCount(0);

        template.sendBodyAndHeader("direct:start", "Hello foo", "foo", "123");
        template.sendBodyAndHeader("direct:start", "Hello bar", "FOO", "456");

        assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                from("direct:start")
                        .choice()
                        .when(header("foo")).to("mock:foo")
                        .otherwise().to("mock:bar");
            }
        };
    }
}
