/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.rest.Utils;

public class RegionScopedBlobStoreContext
extends BaseView
implements BlobStoreContext {
    private final Supplier<Set<String>> regionIds;
    private final Supplier<String> implicitRegionId;
    private final Function<String, BlobStore> blobStore;
    private final Function<String, BlobRequestSigner> blobRequestSigner;
    private final Utils utils;
    private final ConsistencyModel consistencyModel;

    public Set<String> getConfiguredRegions() {
        return (Set)this.regionIds.get();
    }

    public BlobStore getBlobStore(String regionId) {
        this.checkRegionId(regionId);
        return (BlobStore)this.blobStore.apply((Object)regionId);
    }

    public BlobRequestSigner getSigner(String regionId) {
        this.checkRegionId(regionId);
        return (BlobRequestSigner)this.blobRequestSigner.apply((Object)regionId);
    }

    protected void checkRegionId(String regionId) {
        Preconditions.checkArgument((boolean)this.getConfiguredRegions().contains(Preconditions.checkNotNull((Object)regionId, (Object)"regionId was null")), (String)"region %s not in %s", (Object)regionId, this.getConfiguredRegions());
    }

    @Inject
    public RegionScopedBlobStoreContext(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, @Region Supplier<Set<String>> regionIds, @Region Supplier<String> implicitRegionId, Function<String, BlobStore> blobStore, Function<String, BlobRequestSigner> blobRequestSigner, Utils utils, ConsistencyModel consistencyModel) {
        super(backend, backendType);
        this.regionIds = (Supplier)Preconditions.checkNotNull(regionIds, (Object)"regionIds");
        this.implicitRegionId = (Supplier)Preconditions.checkNotNull(implicitRegionId, (Object)"implicitRegionId");
        this.blobStore = (Function)Preconditions.checkNotNull(blobStore, (Object)"blobStore");
        this.blobRequestSigner = (Function)Preconditions.checkNotNull(blobRequestSigner, (Object)"blobRequestSigner");
        this.utils = (Utils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.consistencyModel = (ConsistencyModel)Preconditions.checkNotNull((Object)consistencyModel, (Object)"consistencyModel");
    }

    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    public BlobStore getBlobStore() {
        return this.getBlobStore((String)this.implicitRegionId.get());
    }

    public BlobRequestSigner getSigner() {
        return this.getSigner((String)this.implicitRegionId.get());
    }

    public Utils utils() {
        return this.utils;
    }

    public void close() {
        this.delegate().close();
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return this.delegate().toString();
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

