/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class AddXAuthTokenToRequest
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    AddXAuthTokenToRequest(@Provider Supplier<Credentials> creds) {
        this.creds = creds;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)((Credentials)this.creds.get()), (Object)"credential supplier returned null");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Auth-Token", new String[]{currentCreds.credential})).build();
    }
}

