/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityGroupOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityGroupOption.class);

    SecurityGroupOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (t instanceof EC2TemplateOptions) {
            String[] securityGroups = this.toStringArray(v);
            ((EC2TemplateOptions)t).securityGroups(securityGroups);
        } else if (t instanceof NovaTemplateOptions) {
            String[] securityGroups = this.toStringArray(v);
            t.securityGroups(securityGroups);
        } else if (t instanceof SoftLayerTemplateOptions) {
            String[] securityGroups = this.toStringArray(v);
            t.securityGroups(securityGroups);
        } else if (SecurityGroupOption.isGoogleComputeTemplateOptions(t)) {
            String[] securityGroups = this.toStringArray(v);
            t.securityGroups(securityGroups);
        } else {
            LOG.info("ignoring securityGroups({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
        }
    }

    private String[] toStringArray(Object v) {
        return Strings.toStringList((Object)v).toArray(new String[0]);
    }

    private static boolean isGoogleComputeTemplateOptions(TemplateOptions t) {
        return t.getClass().getName().equals("org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions");
    }
}

