/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.shell.CommandLine;
import io.cloudsoft.winrm4j.client.shell.CommandStateType;
import io.cloudsoft.winrm4j.client.shell.DesiredStreamType;
import io.cloudsoft.winrm4j.client.shell.Receive;
import io.cloudsoft.winrm4j.client.shell.ReceiveResponse;
import io.cloudsoft.winrm4j.client.shell.StreamType;
import io.cloudsoft.winrm4j.client.wsman.CommandResponse;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import io.cloudsoft.winrm4j.client.wsman.OptionSetType;
import io.cloudsoft.winrm4j.client.wsman.OptionType;
import io.cloudsoft.winrm4j.client.wsman.SelectorSetType;
import io.cloudsoft.winrm4j.client.wsman.SelectorType;
import io.cloudsoft.winrm4j.client.wsman.Signal;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.ws.soap.SOAPFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class ShellCommand
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger((String)ShellCommand.class.getName());
    private static final String COMMAND_STATE_DONE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done";
    static final String WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED = "2150858793";
    private static final String WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND = "2150858843";
    private WinRm winrm;
    private SelectorSetType shellSelector;
    private String operationTimeout;
    private Predicate<String> retryReceiveAfterOperationTimeout;
    private final Locale locale;
    private int numberOfReceiveCalls;

    public ShellCommand(WinRm winrm, String shellId, String operationTimeout, Predicate<String> retryReceiveAfterOperationTimeout, Locale locale) {
        this.winrm = winrm;
        this.shellSelector = this.createShellSelector(shellId);
        this.operationTimeout = operationTimeout;
        this.retryReceiveAfterOperationTimeout = retryReceiveAfterOperationTimeout;
        this.locale = locale;
    }

    private SelectorSetType createShellSelector(String shellId) {
        SelectorSetType shellSelector = new SelectorSetType();
        SelectorType sel = new SelectorType();
        sel.setName("ShellId");
        sel.getContent().add(shellId);
        shellSelector.getSelector().add(sel);
        return shellSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String cmd, Writer out, Writer err) {
        WinRmClient.checkNotNull(cmd, "command");
        CommandLine cmdLine = new CommandLine();
        cmdLine.setCommand(cmd);
        OptionSetType optSetCmd = new OptionSetType();
        OptionType optConsolemodeStdin = new OptionType();
        optConsolemodeStdin.setName("WINRS_CONSOLEMODE_STDIN");
        optConsolemodeStdin.setValue("TRUE");
        optSetCmd.getOption().add(optConsolemodeStdin);
        OptionType optSkipCmdShell = new OptionType();
        optSkipCmdShell.setName("WINRS_SKIP_CMD_SHELL");
        optSkipCmdShell.setValue("FALSE");
        optSetCmd.getOption().add(optSkipCmdShell);
        this.numberOfReceiveCalls = 0;
        CommandResponse cmdResponse = this.winrm.command(cmdLine, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd", 153600, this.operationTimeout, this.locale, this.shellSelector, optSetCmd);
        String commandId = cmdResponse.getCommandId();
        try {
            int n = this.receiveCommand(commandId, out, err);
            return n;
        }
        finally {
            try {
                this.releaseCommand(commandId);
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND);
            }
        }
    }

    private int receiveCommand(String commandId, Writer out, Writer err) {
        while (true) {
            Receive receive = new Receive();
            DesiredStreamType stream = new DesiredStreamType();
            stream.setCommandId(commandId);
            stream.setValue("stdout stderr");
            receive.setDesiredStream(stream);
            try {
                ++this.numberOfReceiveCalls;
                ReceiveResponse receiveResponse = this.winrm.receive(receive, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd", 153600, this.operationTimeout, this.locale, this.shellSelector);
                this.getStreams(receiveResponse, out, err);
                CommandStateType state = receiveResponse.getCommandState();
                if (COMMAND_STATE_DONE.equals(state.getState())) {
                    return state.getExitCode().intValue();
                }
                LOG.debug("{} is not done. Response it received: {} / {}", new Object[]{this, state.getState(), receiveResponse});
                continue;
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED, this.retryReceiveAfterOperationTimeout);
                continue;
            }
            break;
        }
    }

    private void assertFaultCode(SOAPFaultException soapFault, String code, Predicate<String> retry) {
        try {
            NodeList faultDetails = soapFault.getFault().getDetail().getChildNodes();
            for (int i = 0; i < faultDetails.getLength(); ++i) {
                if (!faultDetails.item(i).getLocalName().equals("WSManFault")) continue;
                if (faultDetails.item(i).getAttributes().getNamedItem("Code").getNodeValue().equals(code) && retry.test(code)) {
                    LOG.trace("winrm client {} received error 500 response with code {}, response {}", new Object[]{this, code, soapFault});
                    return;
                }
                throw soapFault;
            }
            throw soapFault;
        }
        catch (NullPointerException e) {
            LOG.debug("Error reading Fault Code {}", (Object)soapFault.getFault());
            throw soapFault;
        }
    }

    private void assertFaultCode(SOAPFaultException soapFault, String code) {
        this.assertFaultCode(soapFault, code, x -> true);
    }

    @Deprecated
    public int getNumberOfReceiveCalls() {
        return this.numberOfReceiveCalls;
    }

    private void getStreams(ReceiveResponse receiveResponse, Writer out, Writer err) {
        List<StreamType> streams = receiveResponse.getStream();
        for (StreamType s : streams) {
            byte[] value = s.getValue();
            if (value == null) continue;
            if (out != null && "stdout".equals(s.getName())) {
                try {
                    if (value.length > 0) {
                        out.write(new String(value));
                        out.flush();
                    }
                    if (Boolean.TRUE.equals(s.isEnd())) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (err == null || !"stderr".equals(s.getName())) continue;
            try {
                if (value.length > 0) {
                    err.write(new String(value));
                    err.flush();
                }
                if (!Boolean.TRUE.equals(s.isEnd())) continue;
                err.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void releaseCommand(String commandId) {
        Signal signal = new Signal();
        signal.setCommandId(commandId);
        signal.setCode("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate");
        this.winrm.signal(signal, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd", 153600, this.operationTimeout, this.locale, this.shellSelector);
    }

    @Override
    public void close() {
        try {
            this.winrm.delete("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd", 153600, this.operationTimeout, this.locale, this.shellSelector);
        }
        catch (SOAPFaultException soapFault) {
            this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND);
        }
    }
}

