/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.mgmt;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityTypeRegistry;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;

public interface EntityManager {
    public EntityTypeRegistry getEntityTypeRegistry();

    default public <T extends Entity> T createEntity(EntitySpec<T> spec) {
        return this.createEntity(spec, new EntityCreationOptions(){});
    }

    public <T extends Entity> T createEntity(EntitySpec<T> var1, EntityCreationOptions var2);

    @Deprecated
    public <T extends Entity> T createEntity(Map<?, ?> var1, Class<T> var2);

    public <T extends Policy> T createPolicy(PolicySpec<T> var1);

    public <T extends Enricher> T createEnricher(EnricherSpec<T> var1);

    public Collection<Entity> getEntities();

    public Collection<Entity> getEntitiesInApplication(Application var1);

    public Collection<Entity> findEntities(Predicate<? super Entity> var1);

    public Collection<Entity> findEntitiesInApplication(Application var1, Predicate<? super Entity> var2);

    @Nullable
    public Entity getEntity(String var1);

    public boolean isManaged(Entity var1);

    public void manage(Entity var1);

    public void unmanage(Entity var1);

    public static interface EntityCreationOptions {
        default public <T extends Throwable> void onException(T e, @Nonnull Consumer<? super T> suggestedHandler) {
            suggestedHandler.accept(e);
        }

        default public boolean isDryRun() {
            return false;
        }

        default public String getRequiredUniqueId() {
            return null;
        }

        default public boolean persistAfterCreation() {
            return true;
        }
    }
}

