/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.logging.Logger;

@Singleton
public class InstanceStateStopped
implements Predicate<RunningInstance> {
    private final InstanceApi client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstanceStateStopped(InstanceApi client) {
        this.client = client;
    }

    public boolean apply(RunningInstance instance) {
        this.logger.trace("looking for state on instance %s", new Object[]{instance});
        instance = this.refresh(instance);
        this.logger.trace("%s: looking for instance state %s: currently: %s", new Object[]{instance.getId(), InstanceState.STOPPED, instance.getInstanceState()});
        return instance.getInstanceState() == InstanceState.STOPPED;
    }

    private RunningInstance refresh(RunningInstance instance) {
        Reservation reservation = (Reservation)Iterables.getOnlyElement(this.client.describeInstancesInRegion(instance.getRegion(), instance.getId()));
        return (RunningInstance)Iterables.getOnlyElement((Iterable)((Object)reservation));
    }
}

