/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.NetNamespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetNamespaceFluent<A extends NetNamespaceFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> egressIPs = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer netid;
    private String netname;
    private Map<String, Object> additionalProperties;

    public NetNamespaceFluent() {
    }

    public NetNamespaceFluent(NetNamespace instance) {
        NetNamespace netNamespace = instance = instance != null ? instance : new NetNamespace();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withEgressIPs(instance.getEgressIPs());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNetid(instance.getNetid());
            this.withNetname(instance.getNetname());
            this.withApiVersion(instance.getApiVersion());
            this.withEgressIPs(instance.getEgressIPs());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNetid(instance.getNetid());
            this.withNetname(instance.getNetname());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEgressIPs() {
        return this.egressIPs;
    }

    public String getEgressIP(int index) {
        return this.egressIPs.get(index);
    }

    public String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    public String getLastEgressIP() {
        return this.egressIPs.get(this.egressIPs.size() - 1);
    }

    public String getMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgressIPs(List<String> egressIPs) {
        if (egressIPs != null) {
            this.egressIPs = new ArrayList<String>();
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        } else {
            this.egressIPs = null;
        }
        return (A)((Object)this);
    }

    public A withEgressIPs(String ... egressIPs) {
        if (this.egressIPs != null) {
            this.egressIPs.clear();
            this._visitables.remove((Object)"egressIPs");
        }
        if (egressIPs != null) {
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEgressIPs() {
        return this.egressIPs != null && !this.egressIPs.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Integer getNetid() {
        return this.netid;
    }

    public A withNetid(Integer netid) {
        this.netid = netid;
        return (A)((Object)this);
    }

    public boolean hasNetid() {
        return this.netid != null;
    }

    public String getNetname() {
        return this.netname;
    }

    public A withNetname(String netname) {
        this.netname = netname;
        return (A)((Object)this);
    }

    public boolean hasNetname() {
        return this.netname != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetNamespaceFluent that = (NetNamespaceFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.egressIPs, that.egressIPs)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.netid, that.netid)) {
            return false;
        }
        if (!Objects.equals(this.netname, that.netname)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.egressIPs, this.kind, this.metadata, this.netid, this.netname, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.egressIPs != null && !this.egressIPs.isEmpty()) {
            sb.append("egressIPs:");
            sb.append(this.egressIPs + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.netid != null) {
            sb.append("netid:");
            sb.append(this.netid + ",");
        }
        if (this.netname != null) {
            sb.append("netname:");
            sb.append(this.netname + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)NetNamespaceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

