/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import javax.inject.Inject;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.AccessControlList;

@Beta
public class BackoffOnNotFoundWhenGetBucketACL
extends CacheLoader<String, AccessControlList> {
    private final S3Client client;
    private static final int maxTries = 5;

    @Inject
    BackoffOnNotFoundWhenGetBucketACL(S3Client client) {
        this.client = client;
    }

    public AccessControlList load(String bucketName) {
        ResourceNotFoundException last = null;
        for (int currentTries = 0; currentTries < 5; ++currentTries) {
            try {
                return this.client.getBucketACL(bucketName);
            }
            catch (ResourceNotFoundException e) {
                BackoffOnNotFoundWhenGetBucketACL.imposeBackoffExponentialDelay(100L, 200L, 2, currentTries, 5);
                last = e;
                continue;
            }
        }
        throw last;
    }

    private static void imposeBackoffExponentialDelay(long period, long maxPeriod, int pow, int failureCount, int max) {
        long delayMs = (long)((double)period * Math.pow(failureCount, pow));
        delayMs = delayMs > maxPeriod ? maxPeriod : delayMs;
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return "getBucketAcl()";
    }
}

