/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.config.SetConfigKey;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.tasks.kubectl.PullPolicy;
import org.apache.brooklyn.util.time.Duration;

public interface ContainerCommons {
    public static final ConfigKey<String> CONTAINER_IMAGE = ConfigKeys.newStringConfigKey((String)"image", (String)"Container image");
    public static final ConfigKey<PullPolicy> CONTAINER_IMAGE_PULL_POLICY = ConfigKeys.newConfigKey((TypeToken)new TypeToken<PullPolicy>(){}, (String)"imagePullPolicy", (String)"Container image pull policy. Allowed values: {IfNotPresent, Always, Never}. Default IfNotPresent.", (Object)((Object)PullPolicy.IF_NOT_PRESENT));
    public static final ConfigKey<Boolean> KEEP_CONTAINER_FOR_DEBUGGING = ConfigKeys.newBooleanConfigKey((String)"keepContainerForDebugging", (String)"When set to true, the namespace and associated resources and services are not destroyed after execution. Defaults value is 'false'.", (Boolean)Boolean.FALSE);
    public static final ConfigKey<Object> BASH_SCRIPT = ConfigKeys.newConfigKey(Object.class, (String)"bashScript", (String)"A bash script (as string or list of strings) to run, implies command '/bin/bash' '-c' and replaces arguments");
    public static final ConfigKey<List> COMMAND = ConfigKeys.newConfigKey(List.class, (String)"command", (String)"Single command and optional arguments to execute for the container (overrides image EntryPoint and Cmd)", (Object)Lists.newArrayList());
    public static final ConfigKey<List> ARGUMENTS = ConfigKeys.newConfigKey(List.class, (String)"args", (String)"Additional arguments to pass to the command at the container (in addition to the command supplied here or the default in the image)", (Object)Lists.newArrayList());
    public static final MapConfigKey<Object> SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    public static final ConfigKey<Duration> TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"timeout", (String)"Container execution timeout (default 5 minutes)", (Object)Duration.minutes((Number)5));
    public static final ConfigKey<Boolean> REQUIRE_EXIT_CODE_ZERO = ConfigKeys.newConfigKey(Boolean.class, (String)"requireExitCodeZero", (String)"Whether task should fail if container returns non-zero exit code (default true)", (Object)true);
    public static final ConfigKey<String> WORKING_DIR = ConfigKeys.newStringConfigKey((String)"workingDir", (String)"Location where the container commands are executed");
    public static final ConfigKey<Set<Map<String, String>>> VOLUME_MOUNTS = ((SetConfigKey.Builder)((SetConfigKey.Builder)new SetConfigKey.Builder((TypeToken)new TypeToken<Map<String, String>>(){}, "volumeMounts").description("Configuration to mount a volume into a container.")).defaultValue(null)).build();
    public static final ConfigKey<Set<Map<String, Object>>> VOLUMES = new SetConfigKey.Builder((TypeToken)new TypeToken<Map<String, Object>>(){}, "volumes").description("List of directories with data that is accessible across multiple containers").defaultValue(null).build();
    public static final String NAMESPACE_CREATE_CMD = "kubectl create namespace %s";
    public static final String NAMESPACE_SET_CMD = "kubectl config set-context --current --namespace=%s";
    public static final String JOBS_CREATE_CMD = "kubectl apply -f %s --namespace=%s";
    public static final String JOBS_WAIT_COMPLETE_CMD = "kubectl wait --timeout=%ds --for=condition=complete job/%s --namespace=%s";
    public static final String JOBS_WAIT_FAILED_CMD = "kubectl wait --timeout=%ds --for=condition=failed job/%s --namespace=%s";
    public static final String JOBS_LOGS_CMD = "kubectl logs jobs/%s --namespace=%s";
    public static final String JOBS_DELETE_CMD = "kubectl delete job %s --namespace=%s";
    public static final String PODS_CMD_PREFIX = "kubectl get pods --namespace=%s --selector=job-name=%s ";
    public static final String PODS_STATUS_STATE_CMD = "kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.containerStatuses[0].state}'";
    public static final String PODS_STATUS_PHASE_CMD = "kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.phase}'";
    public static final String PODS_NAME_CMD = "kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].metadata.name}'";
    public static final String PODS_EXIT_CODE_CMD = "kubectl get pods --namespace=%s --selector=job-name=%s -ojsonpath='{.items[0].status.containerStatuses[0].state.terminated.exitCode}'";
    public static final String SCOPED_EVENTS_CMD = "kubectl --namespace %s get events --field-selector=involvedObject.name=%s";
    public static final String SCOPED_EVENTS_FAILED_JSON_CMD = "kubectl --namespace %s get events --field-selector=reason=Failed,involvedObject.name=%s -ojsonpath='{.items}'";
    public static final String NAMESPACE_DELETE_CMD = "kubectl delete namespace %s";

    public static enum PodPhases {
        Failed,
        Running,
        Succeeded,
        Unknown,
        Pending;

    }
}

